/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.util.Collection;
import java.util.HashSet;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ApprovementCertificateRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.student.MobilityProgram;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.ExternalCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.joda.time.DateTime;

public class ApprovementCertificateRequest
extends ApprovementCertificateRequest_Base {
    protected ApprovementCertificateRequest() {
    }

    public ApprovementCertificateRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.setMobilityProgram(bean.getMobilityProgram());
        super.setIgnoreExternalEntries(Boolean.valueOf(bean.isIgnoreExternalEntries()));
        super.setIgnoreCurriculumInAdvance(Boolean.valueOf(bean.isIgnoreCurriculumInAdvance()));
        if (!this.isDEARegistration()) {
            if (this.getRegistration().isConcluded()) {
                throw new DomainException("ApprovementCertificateRequest.registration.is.concluded", new String[0]);
            }
            if (this.getRegistration().isRegistrationConclusionProcessed()) {
                throw new DomainException("ApprovementCertificateRequest.registration.has.conclusion.processed", new String[0]);
            }
        }
        if (this.getEntriesToReport(this.isDEARegistration()).isEmpty()) {
            throw new DomainException("ApprovementCertificateRequest.registration.without.approvements", new String[0]);
        }
    }

    private boolean isDEARegistration() {
        return this.getRegistration().getDegreeType().isAdvancedSpecializationDiploma();
    }

    protected final void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getMobilityProgram() != null && bean.isIgnoreExternalEntries()) {
            throw new DomainException("ApprovementCertificateRequest.cannot.ignore.external.entries.within.a.mobility.program", new String[0]);
        }
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess()) {
            int curricularYear;
            if (!this.isDEARegistration()) {
                if (this.getRegistration().isConcluded()) {
                    throw new DomainException("ApprovementCertificateRequest.registration.is.concluded", new String[0]);
                }
                if (this.getRegistration().isRegistrationConclusionProcessed()) {
                    throw new DomainException("ApprovementCertificateRequest.registration.has.conclusion.processed", new String[0]);
                }
            }
            if (this.getEntriesToReport(this.isDEARegistration()).isEmpty()) {
                throw new DomainException("ApprovementCertificateRequest.registration.without.approvements", new String[0]);
            }
            if (this.getRegistration().getLastStudentCurricularPlan().getDegreeCurricularPlan().getDurationInYears() == 5 && this.getDocumentPurposeType() == DocumentPurposeType.PROFESSIONAL && (curricularYear = this.getRegistration().getCurricularYear()) <= 3) {
                throw new DomainException("ApprovementCertificateRequest.registration.hasnt.finished.third.year", new String[0]);
            }
        }
        if (academicServiceRequestBean.isToConclude()) {
            super.setNumberOfUnits(Integer.valueOf(this.calculateNumberOfUnits()));
        }
    }

    protected boolean isPayed() {
        return super.isPayed();
    }

    public final DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.APPROVEMENT_CERTIFICATE;
    }

    public final String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final EventType getEventType() {
        return this.getRegistration().getRegistrationProtocol().isExempted() ? null : EventType.APPROVEMENT_CERTIFICATE_REQUEST;
    }

    public final Integer getNumberOfUnits() {
        if (!this.hasConcluded()) {
            return this.calculateNumberOfUnits();
        }
        return super.getNumberOfUnits() > 0 ? super.getNumberOfUnits().intValue() : this.calculateNumberOfUnits();
    }

    private int calculateNumberOfUnits() {
        return this.getEntriesToReport(this.isDEARegistration()).size() + this.getExtraCurricularEntriesToReport().size() + this.getPropaedeuticEntriesToReport().size();
    }

    public final void setNumberOfUnits(Integer numberOfUnits) {
        throw new DomainException("error.ApprovementCertificateRequest.cannot.modify.numberOfUnits", new String[0]);
    }

    public void setMobilityProgram(MobilityProgram mobilityProgram) {
        throw new DomainException("error.ApprovementCertificateRequest.cannot.modify", new String[0]);
    }

    public void setIgnoreExternalEntries(Boolean ignoreExternalEntries) {
        throw new DomainException("error.ApprovementCertificateRequest.cannot.modify", new String[0]);
    }

    public boolean isToPrint() {
        return !this.hasConcluded() || super.getNumberOfUnits() != null && super.getNumberOfUnits().intValue() == this.calculateNumberOfUnits();
    }

    private final Collection<ICurriculumEntry> getEntriesToReport(boolean useConcluded) {
        HashSet<ICurriculumEntry> result = new HashSet<ICurriculumEntry>();
        Registration registration = this.getRegistration();
        if (registration.isBolonha()) {
            for (CycleCurriculumGroup cycle : registration.getLastStudentCurricularPlan().getInternalCycleCurriculumGrops()) {
                if (!cycle.hasAnyApprovedCurriculumLines() || !useConcluded && cycle.isConclusionProcessed()) continue;
                Curriculum curriculum = cycle.getCurriculum(this.getFilteringDate());
                ApprovementCertificateRequest.filterEntries(result, this, curriculum);
            }
        } else {
            ICurriculum curriculum = this.getRegistration().getCurriculum(this.getFilteringDate());
            ApprovementCertificateRequest.filterEntries(result, this, curriculum);
        }
        return result;
    }

    public DateTime getFilteringDate() {
        return this.hasConcluded() ? this.getRequestConclusionDate() : new DateTime();
    }

    public static final void filterEntries(Collection<ICurriculumEntry> result, ApprovementCertificateRequest request, ICurriculum curriculum) {
        for (ICurriculumEntry entry : curriculum.getCurriculumEntries()) {
            Dismissal dismissal;
            if (entry instanceof Dismissal ? (dismissal = (Dismissal)entry).getCredits().isEquivalence() || dismissal.isCreditsDismissal() && !dismissal.getCredits().isSubstitution() : entry instanceof ExternalEnrolment && request.getIgnoreExternalEntries() != false) continue;
            result.add(entry);
        }
    }

    public final Collection<ICurriculumEntry> getExtraCurricularEntriesToReport() {
        HashSet<ICurriculumEntry> result = new HashSet<ICurriculumEntry>();
        this.reportApprovedCurriculumLines(result, this.calculateExtraCurriculumLines());
        this.reportExternalGroups(result);
        return result;
    }

    private Collection<CurriculumLine> calculateExtraCurriculumLines() {
        HashSet<CurriculumLine> result = new HashSet<CurriculumLine>();
        for (CurriculumLine line : this.getRegistration().getExtraCurricularCurriculumLines()) {
            if (line.isEnrolment()) {
                if (((Enrolment)((Object)line)).isSourceOfAnyCreditsInCurriculum()) continue;
                result.add(line);
                continue;
            }
            result.add(line);
        }
        return result;
    }

    private void reportApprovedCurriculumLines(Collection<ICurriculumEntry> result, Collection<CurriculumLine> lines) {
        for (CurriculumLine line : lines) {
            if (!line.isApproved()) continue;
            if (line.isEnrolment()) {
                result.add((IEnrolment)((Object)line));
                continue;
            }
            if (!line.isDismissal() || !((Dismissal)((Object)line)).getCredits().isSubstitution()) continue;
            result.addAll(((Dismissal)((Object)line)).getSourceIEnrolments());
        }
    }

    private void reportExternalGroups(Collection<ICurriculumEntry> result) {
        if (this.getIgnoreCurriculumInAdvance() != null && !this.getIgnoreCurriculumInAdvance().booleanValue()) {
            for (ExternalCurriculumGroup group : this.getRegistration().getLastStudentCurricularPlan().getExternalCurriculumGroups()) {
                ApprovementCertificateRequest.filterEntries(result, this, group.getCurriculumInAdvance(this.getFilteringDate()));
            }
        }
    }

    public final Collection<ICurriculumEntry> getPropaedeuticEntriesToReport() {
        HashSet<ICurriculumEntry> result = new HashSet<ICurriculumEntry>();
        this.reportApprovedCurriculumLines(result, this.getRegistration().getPropaedeuticCurriculumLines());
        return result;
    }

    public boolean hasPersonalInfo() {
        return true;
    }
}

