/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum AcademicServiceRequestType {
    DOCUMENT,
    REINGRESSION(true),
    EQUIVALENCE_PLAN(true),
    REVISION_EQUIVALENCE_PLAN(true),
    COURSE_GROUP_CHANGE_REQUEST(true),
    FREE_SOLICITATION_ACADEMIC_REQUEST(true),
    SPECIAL_SEASON_REQUEST(true),
    EXTRA_EXAM_REQUEST(true),
    PHOTOCOPY_REQUEST(true),
    PARTIAL_REGIME_REQUEST(true),
    PHD_STUDENT_REINGRESSION(true),
    DUPLICATE_REQUEST(true),
    DIPLOMA_REQUEST(true),
    DIPLOMA_SUPPLEMENT_REQUEST(true),
    REGISTRY_DIPLOMA_REQUEST(true);

    private boolean isServiceRequest;

    private AcademicServiceRequestType() {
        this.isServiceRequest = false;
    }

    private AcademicServiceRequestType(boolean isForServiceRequest) {
        this.isServiceRequest = isForServiceRequest;
    }

    public String getName() {
        return this.name();
    }

    public String getQualifiedName() {
        return AcademicServiceRequestType.class.getName() + "." + this.name();
    }

    public String getFullyQualifiedName() {
        return AcademicServiceRequestType.class.getName() + "." + this.name();
    }

    public static List<AcademicServiceRequestType> getServiceRequests() {
        ArrayList<AcademicServiceRequestType> result = new ArrayList<AcademicServiceRequestType>();
        for (AcademicServiceRequestType type : AcademicServiceRequestType.values()) {
            if (!type.isServiceRequest) continue;
            result.add(type);
        }
        return result;
    }

    public String localizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.EnumerationResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    protected String localizedName() {
        return this.localizedName(I18N.getLocale());
    }

    public String getLocalizedName() {
        return this.localizedName();
    }
}

