/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituation;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.CourseGroupChangeRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;

public class CourseGroupChangeRequest
extends CourseGroupChangeRequest_Base {
    protected CourseGroupChangeRequest() {
    }

    public CourseGroupChangeRequest(RegistrationAcademicServiceRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.setOldCourseGroup(bean.getCurriculumGroup().getDegreeModule());
        super.setNewCourseGroup(bean.getCourseGroup());
    }

    private void checkParameters(RegistrationAcademicServiceRequestCreateBean bean) {
        CurriculumGroup curriculumGroup = bean.getCurriculumGroup();
        CourseGroup newCourseGroup = bean.getCourseGroup();
        ExecutionYear executionYear = bean.getExecutionYear();
        Registration registration = bean.getRegistration();
        if (curriculumGroup == null) {
            throw new DomainException("error.CourseGroupChangeRequest.curriculumGroup.cannot.be.null", new String[0]);
        }
        if (newCourseGroup == null) {
            throw new DomainException("error.CourseGroupChangeRequest.newCourseGroup.cannot.be.null", new String[0]);
        }
        if (executionYear == null) {
            throw new DomainException("error.CourseGroupChangeRequest.executionYear.cannot.be.null", new String[0]);
        }
        if (!registration.getLastStudentCurricularPlan().hasCurriculumModule((CurriculumModule)((Object)curriculumGroup))) {
            throw new DomainException("error.CourseGroupChangeRequest.invalid.curriculumGroup", new String[0]);
        }
        if (!registration.getLastDegreeCurricularPlan().hasDegreeModule((DegreeModule)((Object)newCourseGroup))) {
            throw new DomainException("error.CourseGroupChangeRequest.invalid.newCourseGroup", new String[0]);
        }
    }

    public void setOldCourseGroup(CourseGroup oldCourseGroup) {
        throw new DomainException("error.CourseGroupChangeRequest.cannot.modify.oldCourseGroup", new String[0]);
    }

    public String getOldCourseGroupOneFullName() {
        return this.getOldCourseGroup() != null ? this.getOldCourseGroup().getOneFullName() : "";
    }

    public void setNewCourseGroup(CourseGroup newCourseGroup) {
        throw new DomainException("error.CourseGroupChangeRequest.cannot.modify.newCourseGroup", new String[0]);
    }

    public String getNewCourseGroupOneFullName() {
        return this.getNewCourseGroup() != null ? this.getNewCourseGroup().getOneFullName() : "";
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.COURSE_GROUP_CHANGE_REQUEST;
    }

    public EventType getEventType() {
        return null;
    }

    protected void disconnect() {
        super.setOldCourseGroup(null);
        super.setNewCourseGroup(null);
        super.disconnect();
    }

    protected void createAcademicServiceRequestSituations(AcademicServiceRequestBean academicServiceRequestBean) {
        super.createAcademicServiceRequestSituations(academicServiceRequestBean);
        if (academicServiceRequestBean.isToConclude()) {
            AcademicServiceRequestSituation.create((AcademicServiceRequest)((Object)this), new AcademicServiceRequestBean(AcademicServiceRequestSituationType.DELIVERED, academicServiceRequestBean.getResponsible()));
        }
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess()) {
            academicServiceRequestBean.setSituationDate(this.getActiveSituation().getSituationDate().toYearMonthDay());
        }
    }

    public boolean isToPrint() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return true;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean hasPersonalInfo() {
        return false;
    }
}

