/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.individualProcess.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramProcessState;
import org.fenixedu.academic.domain.phd.individualProcess.activities.PhdIndividualProgramProcessActivity;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public class ActivatePhdProgramProcessInWorkDevelopmentState
extends PhdIndividualProgramProcessActivity {
    @Override
    protected void processPreConditions(PhdIndividualProgramProcess process2, User userView) {
    }

    @Override
    protected void activityPreConditions(PhdIndividualProgramProcess process2, User userView) {
        if (!process2.isAllowedToManageProcessState(userView)) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdIndividualProgramProcess executeActivity(PhdIndividualProgramProcess process2, User userView, Object object) {
        PhdIndividualProgramProcessBean bean = (PhdIndividualProgramProcessBean)object;
        DateTime stateDate = bean.getStateDate().toDateTimeAtStartOfDay();
        PhdProgramProcessState.createWithGivenStateDate(process2, PhdIndividualProgramProcessState.WORK_DEVELOPMENT, userView.getPerson(), "", stateDate);
        if (process2.getRegistration() == null) {
            return process2;
        }
        if (process2.getRegistration().isConcluded() || process2.getRegistration().isSchoolPartConcluded()) {
            return process2;
        }
        if (process2.getRegistration().isActive()) {
            throw new DomainException("error.PhdIndividualProgramProcess.set.work.development.state.registration.is.active", new String[0]);
        }
        RegistrationState registrationLastActiveState = process2.getRegistration().getLastActiveState();
        if (registrationLastActiveState == null || !registrationLastActiveState.isActive()) {
            throw new DomainException("error.PhdIndividualProgramProcess.set.work.development.state.registration.last.state.is.not.active", new String[0]);
        }
        RegistrationState.createRegistrationState(process2.getRegistration(), userView.getPerson(), stateDate, registrationLastActiveState.getStateType());
        return process2;
    }
}

