/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.individualProcess.activities;

import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.curriculum.EnrollmentCondition;
import org.fenixedu.academic.domain.phd.ManageEnrolmentsBean;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.individualProcess.activities.PhdIndividualProgramProcessActivity;
import org.fenixedu.bennu.core.domain.User;

public class AcceptEnrolments
extends PhdIndividualProgramProcessActivity {
    @Override
    public void activityPreConditions(PhdIndividualProgramProcess process2, User userView) {
        if (!process2.isCoordinatorForPhdProgram(userView.getPerson())) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdIndividualProgramProcess executeActivity(PhdIndividualProgramProcess process2, User userView, Object object) {
        ManageEnrolmentsBean bean = (ManageEnrolmentsBean)object;
        for (Enrolment enrolment : bean.getEnrolmentsToValidate()) {
            if (!process2.getRegistration().hasEnrolments(enrolment)) continue;
            enrolment.setEnrolmentCondition(EnrollmentCondition.VALIDATED);
        }
        AlertService.alertStudent(process2, AlertService.AlertMessage.create(bean.getMailSubject(), new Object[0]).isKey(false), AlertService.AlertMessage.create(this.buildBody(bean), new Object[0]).isKey(false));
        return process2;
    }

    private String buildBody(ManageEnrolmentsBean bean) {
        StringBuilder sb = new StringBuilder();
        sb.append(AlertService.getMessageFromResource("label.phd.accepted.enrolments")).append("\n");
        for (Enrolment enrolment : bean.getEnrolmentsToValidate()) {
            sb.append("- ").append(enrolment.getPresentationName()).append(enrolment.getExecutionPeriod().getQualifiedName()).append("\n");
        }
        return sb.toString();
    }
}

