/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.Locale;
import java.util.Set;
import jvstm.cps.ConsistencyPredicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType_Base;
import org.fenixedu.academic.domain.organizationalStructure.ConnectionRule;
import org.fenixedu.academic.domain.organizationalStructure.PartyType;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;

public class AccountabilityType
extends AccountabilityType_Base {
    protected AccountabilityType() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public AccountabilityType(AccountabilityTypeEnum accountabilityTypeEnum, MultiLanguageString name) {
        this();
        this.setType(accountabilityTypeEnum);
        this.setTypeName(name);
    }

    public void setType(AccountabilityTypeEnum type) {
        if (type == null) {
            throw new DomainException("error.accountabilityType.empty.type", new String[0]);
        }
        super.setType(type);
    }

    public static AccountabilityType readByType(AccountabilityTypeEnum typeEnum) {
        Set allAccountabilityTypes = Bennu.getInstance().getAccountabilityTypesSet();
        for (AccountabilityType accountabilityType : allAccountabilityTypes) {
            if (!accountabilityType.getType().equals((Object)typeEnum)) continue;
            return accountabilityType;
        }
        return null;
    }

    public void setTypeName(MultiLanguageString typeName) {
        if (typeName == null || typeName.isEmpty()) {
            throw new DomainException("error.accountabilityType.empty.typeName", new String[0]);
        }
        super.setTypeName(typeName);
    }

    @ConsistencyPredicate
    protected boolean checkRequiredParameters() {
        return this.getType() != null && this.getTypeName() != null && !this.getTypeName().isEmpty();
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isSharedFunction() {
        return false;
    }

    public String getName() {
        return this.getTypeName().getPreferedContent();
    }

    public void setName(String name) {
        if (name == null || StringUtils.isEmpty((String)name.trim())) {
            throw new DomainException("error.accountabilityType.empty.name", new String[0]);
        }
        MultiLanguageString typeName = this.getTypeName();
        typeName = typeName == null ? new MultiLanguageString(Locale.getDefault(), name) : typeName.with(Locale.getDefault(), name);
        this.setTypeName(typeName);
    }

    public boolean hasConnectionRuleFor(PartyType parentType, PartyType childType) {
        return this.getConnectionRuleFor(parentType, childType) != null;
    }

    public ConnectionRule getConnectionRuleFor(PartyType parentType, PartyType childType) {
        for (ConnectionRule connectionRule : this.getConnectionRulesSet()) {
            if (!connectionRule.isValid(parentType, childType)) continue;
            return connectionRule;
        }
        return null;
    }

    public ConnectionRule addConnectionRule(PartyType parentType, PartyType childType, Boolean managedByUser) {
        ConnectionRule result = new ConnectionRule(parentType, childType, this);
        result.setManagedByUser(managedByUser);
        return result;
    }

    public boolean canConnect(PartyType parentType, PartyType childType) {
        for (ConnectionRule connectionRule : this.getConnectionRulesSet()) {
            if (!connectionRule.isValid(parentType, childType)) continue;
            return true;
        }
        return false;
    }
}

