/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit_Base;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.GenericPair;

public class CreditsLimit
extends CreditsLimit_Base {
    private CreditsLimit(Double minimum, Double maximum) {
        this.checkCredits(minimum, maximum);
        this.setMinimumCredits(minimum);
        this.setMaximumCredits(maximum);
        this.setCurricularRuleType(CurricularRuleType.CREDITS_LIMIT);
    }

    public CreditsLimit(DegreeModule degreeModuleToApplyRule, CourseGroup contextCourseGroup, ExecutionSemester begin, ExecutionSemester end, Double minimum, Double maximum) {
        this(minimum, maximum);
        this.checkParameters(degreeModuleToApplyRule);
        this.init(degreeModuleToApplyRule, contextCourseGroup, begin, end);
    }

    private void checkParameters(DegreeModule degreeModuleToApplyRule) {
        if (degreeModuleToApplyRule.isLeaf() && !degreeModuleToApplyRule.isOptional()) {
            throw new DomainException("error.curricularRules.CreditsLimit.invalid.degreeModule.must.be.group.or.optional.curricularCourse", new String[0]);
        }
    }

    protected void edit(CourseGroup contextCourseGroup, Double minimumCredits, Double maximumCredits) {
        this.checkCredits(minimumCredits, maximumCredits);
        this.setContextCourseGroup(contextCourseGroup);
        this.setMinimumCredits(minimumCredits);
        this.setMaximumCredits(maximumCredits);
    }

    private void checkCredits(Double minimum, Double maximum) throws DomainException {
        if (minimum == null || maximum == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        if (minimum > maximum) {
            throw new DomainException("error.minimum.greater.than.maximum", new String[0]);
        }
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        ArrayList<GenericPair<Object, Boolean>> labelList = new ArrayList<GenericPair<Object, Boolean>>();
        labelList.add(new GenericPair<String, Boolean>("label.creditsForApproval", true));
        labelList.add(new GenericPair<String, Boolean>(": ", false));
        if (this.getMinimumCredits().doubleValue() == this.getMaximumCredits().doubleValue()) {
            labelList.add(new GenericPair<Double, Boolean>(this.getMinimumCredits(), false));
        } else {
            labelList.add(new GenericPair<Double, Boolean>(this.getMinimumCredits(), false));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.to", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<Double, Boolean>(this.getMaximumCredits(), false));
        }
        if (this.getContextCourseGroup() != null) {
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<String, Boolean>("label.inGroup", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getContextCourseGroup().getOneFullName(), false));
        }
        return labelList;
    }

    protected void removeOwnParameters() {
    }

    public boolean allowCredits(Double numberOfCredits) {
        return numberOfCredits.compareTo(this.getMinimumCredits()) >= 0 && numberOfCredits.compareTo(this.getMaximumCredits()) <= 0;
    }

    public boolean creditsExceedMaximum(Double numberOfCredits) {
        return numberOfCredits.compareTo(this.getMaximumCredits()) > 0;
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }
}

