/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.util.Collection;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.ServiceAgreementPaymentPlan;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.ServiceAgreement_Base;
import org.fenixedu.academic.domain.accounting.paymentPlans.CustomGratuityPaymentPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public abstract class ServiceAgreement
extends ServiceAgreement_Base {
    protected ServiceAgreement() {
        super.setCreationDate(new DateTime());
        super.setRootDomainObject(Bennu.getInstance());
    }

    protected void init(Person person, ServiceAgreementTemplate serviceAgreementTemplate) {
        this.checkParameters(person, serviceAgreementTemplate);
        super.setPerson(person);
        super.setServiceAgreementTemplate(serviceAgreementTemplate);
    }

    private void checkParameters(Person person, ServiceAgreementTemplate serviceAgreementTemplate) {
        if (person == null) {
            throw new DomainException("error.accounting.agreement.serviceAgreement.person.cannot.be.null", new String[0]);
        }
        if (serviceAgreementTemplate == null) {
            throw new DomainException("error.accounting.agreement.serviceAgreement.serviceAgreementTemplate.cannot.be.null", new String[0]);
        }
    }

    public void setCreationDate(DateTime creationDate) {
        throw new DomainException("error.accounting.agreement.serviceAgreement.cannot.modify.creationDate", new String[0]);
    }

    public void setPerson(Person person) {
        throw new DomainException("error.accounting.agreement.serviceAgreement.cannot.modify.person", new String[0]);
    }

    public void setServiceAgreementTemplate(ServiceAgreementTemplate serviceAgreementTemplate) {
        throw new DomainException("error.accounting.agreement.serviceAgreement.cannot.modify.serviceAgreementTemplate", new String[0]);
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        super.setPerson(null);
        super.setServiceAgreementTemplate(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getPaymentPlansSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.ServiceAgreement.cannot.delete", (String[])new String[0]));
        }
    }

    public CustomGratuityPaymentPlan getCustomGratuityPaymentPlan(ExecutionYear executionYear) {
        for (ServiceAgreementPaymentPlan paymentPlan : this.getPaymentPlansSet()) {
            if (!(paymentPlan instanceof CustomGratuityPaymentPlan) || !paymentPlan.isFor(executionYear)) continue;
            return (CustomGratuityPaymentPlan)((Object)paymentPlan);
        }
        return null;
    }

    public boolean hasCustomGratuityPaymentPlan(ExecutionYear executionYear) {
        return this.getCustomGratuityPaymentPlan(executionYear) != null;
    }

    static {
        ServiceAgreement.getRelationServiceAgreementPerson().addListener((RelationListener)new RelationAdapter<ServiceAgreement, Person>(){

            public void beforeAdd(ServiceAgreement serviceAgreementToAdd, Person person) {
                if (serviceAgreementToAdd != null && person != null) {
                    for (ServiceAgreement serviceAgreement : person.getServiceAgreementsSet()) {
                        if (serviceAgreement.getServiceAgreementTemplate() != serviceAgreementToAdd.getServiceAgreementTemplate()) continue;
                        throw new DomainException("error.accounting.ServiceAgreement.person.already.has.service.agreement.for.service.agreement.template", new String[0]);
                    }
                }
            }
        });
    }
}

