/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.fenixedu.academic.domain.exceptions.DomainException;

@Deprecated
public class FileUtils {
    private static final String TEMPORARY_FILE_GLOBAL_UNIQUE_NAME_PREFIX = UUID.randomUUID().toString();
    private static final char[] SEPARATOR_CHARS = new char[]{'\\', '/'};

    public static String getTemporaryFileBaseName() {
        return TEMPORARY_FILE_GLOBAL_UNIQUE_NAME_PREFIX;
    }

    public static File createTemporaryFile() throws IOException {
        File temporaryFile = File.createTempFile(TEMPORARY_FILE_GLOBAL_UNIQUE_NAME_PREFIX, "");
        temporaryFile.deleteOnExit();
        return temporaryFile;
    }

    public static File copyToTemporaryFile(InputStream inputStream) throws IOException {
        File temporaryFile = FileUtils.createTemporaryFile();
        FileOutputStream targetFileOutputStream = null;
        try {
            targetFileOutputStream = new FileOutputStream(temporaryFile);
            ByteStreams.copy((InputStream)inputStream, (OutputStream)targetFileOutputStream);
        }
        finally {
            if (targetFileOutputStream != null) {
                targetFileOutputStream.close();
            }
            inputStream.close();
        }
        return temporaryFile;
    }

    public static String getFilenameOnly(String filename) {
        for (char separatorChar : SEPARATOR_CHARS) {
            if (filename.lastIndexOf(separatorChar) == -1) continue;
            return filename.substring(filename.lastIndexOf(separatorChar) + 1);
        }
        return filename;
    }

    public static String cleanupUserInputFilename(String filename) {
        return FileUtils.getFilenameOnly(filename);
    }

    public static String cleanupUserInputFileDisplayName(String displayName) {
        String filenamePart = FileUtils.getFilenameOnly(displayName);
        String validChars = "_\\- .,:;!()*$&'=@";
        if (!Pattern.matches("[\\p{IsLatin}0-9" + validChars + "]+", filenamePart)) {
            throw new DomainException("errors.file.displayName.invalid.characters", validChars.replace("\\", ""));
        }
        return filenamePart;
    }

    public static File unzipFile(File file) throws IOException {
        File tempDir = Files.createTempDir();
        FileUtils.copyFileToAnotherDirWithRelativePaths(file.getParentFile(), tempDir, file);
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            File zipContentFile = null;
            File zipContentFileParentDir = null;
            while (zipEntry != null) {
                zipEntry.getName();
                zipContentFile = new File(tempDir, zipEntry.getName());
                zipContentFileParentDir = zipContentFile.getParentFile();
                zipContentFileParentDir.mkdirs();
                if (!zipEntry.isDirectory()) {
                    zipContentFile.createNewFile();
                } else {
                    zipContentFile.mkdirs();
                }
                zipContentFile.deleteOnExit();
                if (!zipEntry.isDirectory() && zipContentFile.exists() && zipContentFile.canWrite()) {
                    try (FileOutputStream zipOs = new FileOutputStream(zipContentFile);){
                        ByteStreams.copy((InputStream)zipInputStream, (OutputStream)zipOs);
                    }
                }
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        return tempDir;
    }

    public static String makeRelativePath(String absoluteParentPath, String originalAbsoluteFilePath, String uniqueId) {
        if (originalAbsoluteFilePath != null && absoluteParentPath != null && originalAbsoluteFilePath.length() > absoluteParentPath.length()) {
            return originalAbsoluteFilePath.substring(absoluteParentPath.length() + 1);
        }
        return uniqueId;
    }

    /*
     * Exception decompiling
     */
    public static File copyFileToAnotherDirWithRelativePaths(File srcDir, File destDir, File originalFile) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

