/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager.utils;

import javax.servlet.http.HttpServletRequest;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.dto.InfoExecutionYear;
import org.fenixedu.academic.service.services.commons.ReadExecutionPeriod;
import org.fenixedu.academic.service.services.commons.ReadExecutionYear;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.publico.ReadExecutionCourse;
import org.fenixedu.academic.service.services.publico.ReadExecutionDegreesByExecutionYearAndDegreeInitials;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import pt.ist.fenixframework.FenixFramework;

public abstract class RequestUtils {
    public static final InfoExecutionCourse getExecutionCourseBySigla(HttpServletRequest request, String infoExecutionCourseInitials) throws Exception {
        AcademicInterval academicInterval = AcademicInterval.getAcademicIntervalFromResumedString((String)request.getAttribute("academicInterval"));
        ExecutionCourse executionCourse = ExecutionCourse.getExecutionCourseByInitials(academicInterval, infoExecutionCourseInitials);
        if (executionCourse != null) {
            return InfoExecutionCourse.newInfoFromDomain(executionCourse);
        }
        throw new IllegalArgumentException("Not find executionCourse!");
    }

    public static final InfoExecutionCourse getExecutionCourseFromRequest(HttpServletRequest request) throws FenixActionException, FenixServiceException {
        InfoExecutionCourse infoExecutionCourse = null;
        InfoExecutionPeriod infoExecutionPeriod = RequestUtils.getExecutionPeriodFromRequest(request);
        String code = request.getParameter("exeCode");
        infoExecutionCourse = (InfoExecutionCourse)ReadExecutionCourse.run(infoExecutionPeriod, code);
        return infoExecutionCourse;
    }

    public static final InfoExecutionYear getExecutionYearFromRequest(HttpServletRequest request) throws FenixActionException, FenixServiceException {
        InfoExecutionYear infoExecutionYear = null;
        String year = (String)request.getAttribute("eYName");
        if (year == null) {
            year = request.getParameter("eYName");
        }
        if (year != null) {
            infoExecutionYear = ReadExecutionYear.run(year);
        }
        return infoExecutionYear;
    }

    public static final InfoExecutionPeriod getExecutionPeriodFromRequest(HttpServletRequest request) throws FenixActionException {
        InfoExecutionYear infoExecutionYear;
        InfoExecutionPeriod infoExecutionPeriod = null;
        try {
            infoExecutionYear = RequestUtils.getExecutionYearFromRequest(request);
        }
        catch (FenixServiceException e) {
            throw new FenixActionException(e);
        }
        String name = (String)request.getAttribute("ePName");
        if (name == null) {
            name = request.getParameter("ePName");
        }
        if (name != null & infoExecutionYear != null) {
            infoExecutionPeriod = ReadExecutionPeriod.run(name, infoExecutionYear);
        }
        return infoExecutionPeriod;
    }

    public static final InfoExecutionDegree getExecutionDegreeFromRequest(HttpServletRequest request, InfoExecutionYear infoExecutionYear) throws FenixActionException {
        InfoExecutionDegree infoExecutionDegree = (InfoExecutionDegree)request.getAttribute("exeDegree");
        if (infoExecutionDegree != null) {
            return infoExecutionDegree;
        }
        String degreeInitials = (String)request.getAttribute("degreeInitials");
        String nameDegreeCurricularPlan = (String)request.getAttribute("nameDegreeCurricularPlan");
        if (degreeInitials == null) {
            degreeInitials = request.getParameter("degreeInitials");
        }
        if (nameDegreeCurricularPlan == null) {
            nameDegreeCurricularPlan = request.getParameter("nameDegreeCurricularPlan");
        }
        infoExecutionDegree = ReadExecutionDegreesByExecutionYearAndDegreeInitials.run(infoExecutionYear, degreeInitials, nameDegreeCurricularPlan);
        return infoExecutionDegree;
    }

    public static final void setExecutionPeriodToRequest(HttpServletRequest request, InfoExecutionPeriod infoExecutionPeriod) {
        if (infoExecutionPeriod != null) {
            request.setAttribute("ePName", (Object)infoExecutionPeriod.getName());
            request.setAttribute("eYName", (Object)infoExecutionPeriod.getInfoExecutionYear().getYear());
        }
    }

    public static final void setExecutionDegreeToRequest(HttpServletRequest request, InfoExecutionDegree executionDegree) {
        if (executionDegree != null) {
            request.setAttribute("exeDegree", (Object)executionDegree);
            request.setAttribute("nameDegreeCurricularPlan", (Object)executionDegree.getInfoDegreeCurricularPlan().getName());
            if (executionDegree.getInfoDegreeCurricularPlan().getInfoDegree() != null) {
                request.setAttribute("degreeInitials", (Object)executionDegree.getInfoDegreeCurricularPlan().getInfoDegree().getSigla());
            }
            request.setAttribute("degreeCurricularPlanID", (Object)executionDegree.getInfoDegreeCurricularPlan().getExternalId());
            request.setAttribute("executionDegree", (Object)FenixFramework.getDomainObject((String)executionDegree.getExternalId()));
        }
    }
}

