/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.thesis.academicAdminOffice;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdEditMeetingBean;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeeting;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingBean;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.ScheduleFirstThesisMeeting;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.ScheduleFirstThesisMeetingRequest;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.ScheduleThesisMeeting;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.ScheduleThesisMeetingRequest;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.SubmitThesisMeetingMinutes;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice.PhdIndividualProgramProcessDA;
import org.fenixedu.academic.ui.struts.action.phd.thesis.CommonPhdThesisProcessDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/phdMeetingSchedulingProcess", module="academicAdministration", functionality=PhdIndividualProgramProcessDA.class)
@Forwards(value={@Forward(name="requestScheduleFirstThesisMeeting", path="/phd/thesis/academicAdminOffice/requestScheduleFirstThesisMeeting.jsp"), @Forward(name="scheduleFirstThesisMeeting", path="/phd/thesis/academicAdminOffice/scheduleFirstThesisMeeting.jsp"), @Forward(name="requestScheduleThesisMeeting", path="/phd/thesis/academicAdminOffice/requestScheduleThesisMeeting.jsp"), @Forward(name="scheduleThesisMeeting", path="/phd/thesis/academicAdminOffice/scheduleThesisMeeting.jsp"), @Forward(name="submitThesisMeetingMinutes", path="/phd/thesis/academicAdminOffice/submitThesisMeetingMinutes.jsp"), @Forward(name="viewMeetingSchedulingProcess", path="/phd/thesis/academicAdminOffice/viewMeetingSchedulingProcess.jsp"), @Forward(name="editMeetingAttributes", path="/phd/thesis/academicAdminOffice/editMeetingAttributes.jsp")})
public class PhdMeetingSchedulingProcessDA
extends CommonPhdThesisProcessDA {
    public ActionForward prepareRequestScheduleFirstThesisMeeting(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)new PhdThesisProcessBean());
        return mapping.findForward("requestScheduleFirstThesisMeeting");
    }

    public ActionForward requestScheduleFirstThesisMeeting(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)this.getRenderedObject("thesisProcessBean");
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request).getMeetingProcess()), ScheduleFirstThesisMeetingRequest.class, (Object)bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute("thesisProcessBean", (Object)bean);
            return mapping.findForward("requestScheduleThesisMeeting");
        }
        return this.viewMeetingSchedulingProcess(request, this.getProcess(request));
    }

    public ActionForward prepareScheduleFirstThesisMeeting(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        PhdThesisProcess thesisProcess = this.getProcess(request);
        bean.setThesisProcess(thesisProcess);
        this.setDefaultMeetingMailInformation(bean, thesisProcess);
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("scheduleFirstThesisMeeting");
    }

    public ActionForward scheduleFirstThesisMeetingInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        return mapping.findForward("scheduleFirstThesisMeeting");
    }

    public ActionForward scheduleFirstThesisMeetingPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        RenderUtils.invalidateViewState();
        return mapping.findForward("scheduleFirstThesisMeeting");
    }

    public ActionForward scheduleFirstThesisMeeting(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcess thesisProcess = this.getProcess(request);
        try {
            ExecuteProcessActivity.run((Process)((Object)thesisProcess.getMeetingProcess()), ScheduleFirstThesisMeeting.class, (Object)this.getThesisProcessBean());
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.scheduleThesisMeetingInvalid(mapping, actionForm, request, response);
        }
        return this.viewMeetingSchedulingProcess(request, this.getProcess(request));
    }

    public ActionForward prepareRequestScheduleThesisMeeting(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)new PhdThesisProcessBean());
        return mapping.findForward("requestScheduleThesisMeeting");
    }

    public ActionForward requestScheduleThesisMeeting(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)this.getRenderedObject("thesisProcessBean");
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request).getMeetingProcess()), ScheduleThesisMeetingRequest.class, (Object)bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute("thesisProcessBean", (Object)bean);
            return mapping.findForward("requestScheduleThesisMeeting");
        }
        return this.viewMeetingSchedulingProcess(request, this.getProcess(request));
    }

    @Override
    public ActionForward prepareScheduleThesisMeeting(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        PhdThesisProcess thesisProcess = this.getProcess(request);
        bean.setThesisProcess(thesisProcess);
        this.setDefaultMeetingMailInformation(bean, thesisProcess);
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("scheduleThesisMeeting");
    }

    private void setDefaultMeetingMailInformation(PhdThesisProcessBean bean, PhdThesisProcess thesisProcess) {
        PhdIndividualProgramProcess process2 = thesisProcess.getIndividualProgramProcess();
        bean.setMailSubject(AlertService.getSubjectPrefixed(process2, "message.phd.thesis.schedule.thesis.meeting.default.subject"));
        bean.setMailBody(AlertService.getBodyText(process2, "message.phd.thesis.schedule.thesis.meeting.default.body"));
    }

    @Override
    public ActionForward scheduleThesisMeetingInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        return mapping.findForward("scheduleThesisMeeting");
    }

    @Override
    public ActionForward scheduleThesisMeetingPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        RenderUtils.invalidateViewState();
        return mapping.findForward("scheduleThesisMeeting");
    }

    @Override
    public ActionForward scheduleThesisMeeting(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcess thesisProcess = this.getProcess(request);
        try {
            ExecuteProcessActivity.run((Process)((Object)thesisProcess.getMeetingProcess()), ScheduleThesisMeeting.class, (Object)this.getThesisProcessBean());
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.scheduleThesisMeetingInvalid(mapping, actionForm, request, response);
        }
        return this.viewMeetingSchedulingProcess(request, this.getProcess(request));
    }

    public ActionForward prepareSubmitThesisMeetingMinutes(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdMeetingBean bean = new PhdMeetingBean();
        PhdMeeting meeting = this.getPhdMeeting(request);
        bean.setDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.JURY_MEETING_MINUTES));
        bean.setMeeting(meeting);
        bean.setMeetingProcess(meeting.getMeetingProcess());
        request.setAttribute("meetingBean", (Object)bean);
        return mapping.findForward("submitThesisMeetingMinutes");
    }

    public ActionForward prepareSubmitThesisMeetingMinutesInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RenderUtils.invalidateViewState((String)"meetingBean.edit.document");
        request.setAttribute("meetingBean", this.getRenderedObject("meetingBean"));
        return mapping.findForward("submitThesisMeetingMinutes");
    }

    public ActionForward submitThesisMeetingMinutes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdMeetingBean meetingBean = (PhdMeetingBean)this.getRenderedObject("meetingBean");
        try {
            ExecuteProcessActivity.run((Process)((Object)meetingBean.getMeetingProcess()), SubmitThesisMeetingMinutes.class, (Object)meetingBean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.prepareSubmitThesisMeetingMinutesInvalid(mapping, form, request, response);
        }
        return this.viewMeetingSchedulingProcess(request, this.getProcess(request));
    }

    private ActionForward viewMeetingSchedulingProcess(HttpServletRequest request, PhdThesisProcess process2) {
        return this.redirect(String.format("/phdThesisProcess.do?method=viewMeetingSchedulingProcess&processId=%s", process2.getExternalId()), request);
    }

    private PhdMeeting getPhdMeeting(HttpServletRequest request) {
        return (PhdMeeting)((Object)this.getDomainObject(request, "meetingId"));
    }

    public ActionForward viewMeetingSchedulingProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.viewMeetingSchedulingProcess(request, this.getProcess(request));
    }

    public ActionForward prepareEditMeetingAttributes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdMeeting meeting = (PhdMeeting)((Object)this.getDomainObject(request, "meetingId"));
        PhdEditMeetingBean bean = new PhdEditMeetingBean(meeting);
        request.setAttribute("process", (Object)this.getProcess(request));
        request.setAttribute("meeting", (Object)meeting);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("editMeetingAttributes");
    }

    public ActionForward editMeetingAttributes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdMeeting meeting = (PhdMeeting)((Object)this.getDomainObject(request, "meetingId"));
        PhdThesisProcess process2 = this.getProcess(request);
        PhdEditMeetingBean bean = (PhdEditMeetingBean)this.getRenderedObject("bean");
        meeting.editAttributes(bean);
        String link = "/phdThesisProcess.do?method=viewMeetingSchedulingProcess&amp;processId=" + process2.getExternalId();
        return new ActionForward(link, false);
    }

    public ActionForward editMeetingAttributesInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdMeeting meeting = (PhdMeeting)((Object)this.getDomainObject(request, "meetingId"));
        PhdThesisProcess process2 = this.getProcess(request);
        PhdEditMeetingBean bean = (PhdEditMeetingBean)this.getRenderedObject("bean");
        request.setAttribute("process", (Object)process2);
        request.setAttribute("meeting", (Object)meeting);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("editMeetingAttributes");
    }
}

