/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice;

import java.io.Serializable;
import java.util.Comparator;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accounting.events.AccountingEventsManager;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithInvocationResult;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramProcessState;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityEvent;
import org.fenixedu.academic.domain.phd.debts.PhdRegistrationFee;
import org.fenixedu.academic.dto.accounting.events.AccountingEventCreateBean;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.phd.PhdProcessDA;
import org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice.PhdIndividualProgramProcessDA;
import org.fenixedu.academic.util.InvocationResult;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Mapping(path="/phdAccountingEventsManagement", module="academicAdministration", functionality=PhdIndividualProgramProcessDA.class)
@Forwards(value={@Forward(name="chooseEventType", path="/phd/academicAdminOffice/payments/chooseEventType.jsp"), @Forward(name="chooseYear", path="/phd/academicAdminOffice/payments/chooseYear.jsp"), @Forward(name="chooseYear2", path="/phd/academicAdminOffice/payments/chooseYear2.jsp"), @Forward(name="createInsuranceEvent", path="/phd/academicAdminOffice/payments/createInsuranceEvent.jsp")})
public class PhdAccountingEventsManagementDA
extends PhdProcessDA {
    protected PhdIndividualProgramProcess getProcess(HttpServletRequest request) {
        return (PhdIndividualProgramProcess)((Object)super.getProcess(request));
    }

    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("chooseEventType");
    }

    public ActionForward createPhdRegistrationFee(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdRegistrationFee.create(this.getProcess(request));
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
        }
        return this.prepare(mapping, actionForm, request, response);
    }

    public ActionForward prepareCreateInsuranceEvent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("eventBean", (Object)new AccountingEventCreateBean());
        return mapping.findForward("createInsuranceEvent");
    }

    public ActionForward updatePrepareCreateGratuityEvent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("yearBean", request.getAttribute("yearBean"));
        return mapping.findForward("chooseYear");
    }

    public ActionForward prepareCreateGratuityEvent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("yearBean", (Object)new PhdGratuityCreationInformation());
        return mapping.findForward("chooseYear");
    }

    public ActionForward createGratuityEvent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdGratuityCreationInformation renderedObject = (PhdGratuityCreationInformation)this.getRenderedObject("yearBean");
            for (PhdGratuityEvent event : this.getProcess(request).getPhdGratuityEventsSet()) {
                if (event.getYear().intValue() != ((PhdGratuityCreationInformation)this.getRenderedObject("yearBean")).getYear() || !event.isOpen()) continue;
                throw new DomainException("already.has.phd.gratuity.for.that.year", new String[0]);
            }
            PhdIndividualProgramProcess process2 = this.getProcess(request);
            TreeSet<PhdProgramProcessState> orderdStates = new TreeSet<PhdProgramProcessState>(new Comparator<PhdProgramProcessState>(){

                @Override
                public int compare(PhdProgramProcessState o1, PhdProgramProcessState o2) {
                    return o1.getStateDate().compareTo((ReadableInstant)o2.getStateDate());
                }
            });
            orderdStates.addAll(process2.getStates());
            int lastOpenYear = new DateTime().getYear();
            int year = renderedObject.getYear();
            boolean yearWithinWorkingDevelopmentPeriod = false;
            for (PhdProgramProcessState state : process2.getStates()) {
                if (state.getType().equals(PhdIndividualProgramProcessState.WORK_DEVELOPMENT) && state.getStateDate().getYear() <= year && year <= lastOpenYear) {
                    yearWithinWorkingDevelopmentPeriod = true;
                    break;
                }
                lastOpenYear = state.getStateDate().getYear();
            }
            if (!yearWithinWorkingDevelopmentPeriod) {
                throw new FenixActionException("error.chosen.year.not.within.working.period");
            }
            PhdGratuityEvent.create(this.getProcess(request), year, process2.getWhenFormalizedRegistration().toDateTimeAtMidnight());
            return this.prepare(mapping, actionForm, request, response);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
        }
        catch (FenixActionException e) {
            this.addErrorMessage(request, e.getMessage(), new String[0]);
        }
        return this.prepareCreateGratuityEvent(mapping, actionForm, request, response);
    }

    public ActionForward prepareCreateInsuranceEventInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("eventBean", this.getRenderedObject("eventBean"));
        return mapping.findForward("createInsuranceEvent");
    }

    public ActionForward createPhdThesisRequestFee(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.getProcess(request).getThesisProcess().createRequestFee();
            this.addActionMessage("success", request, "message.phd.accounting.events.create.thesis.request.fee.created.with.success");
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        return this.prepare(mapping, actionForm, request, response);
    }

    public ActionForward createInsuranceEvent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            AccountingEventCreateBean bean = (AccountingEventCreateBean)this.getRenderedObject("eventBean");
            PhdIndividualProgramProcess process2 = this.getProcess(request);
            if (process2.getExecutionYear().isAfter(bean.getExecutionYear())) {
                this.addActionMessage("error", request, "error.phd.accounting.events.insurance.invalid.execution.period", process2.getExecutionYear().getQualifiedName());
                return this.prepareCreateInsuranceEvent(mapping, actionForm, request, response);
            }
            InvocationResult result = new AccountingEventsManager().createInsuranceEvent(process2.getPerson(), bean.getExecutionYear());
            if (result.isSuccess()) {
                this.addActionMessage("success", request, "message.phd.accounting.events.insurance.created.with.success");
                return this.prepare(mapping, actionForm, request, response);
            }
            this.addActionMessages("error", request, result.getMessages());
        }
        catch (DomainExceptionWithInvocationResult e) {
            this.addActionMessages("error", request, e.getInvocationResult().getMessages());
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
        }
        return this.prepareCreateInsuranceEvent(mapping, actionForm, request, response);
    }

    public static class PhdGratuityCreationInformation
    implements Serializable {
        private int year = new DateTime().getYear();

        public void setYear(int year) {
            this.year = year;
        }

        public int getYear() {
            return this.year;
        }
    }
}

