/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.enrolments;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.academic.ui.struts.action.manager.enrolments.SpecialSeasonStatusTrackerBean;
import org.fenixedu.academic.ui.struts.action.manager.enrolments.SpecialSeasonStatusTrackerRegisterBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=ManagerApplications.ManagerStudentsApp.class, path="special-season-enrolments", titleKey="label.course.specialSeasonEnrolments")
@Mapping(path="/specialSeason/specialSeasonStatusTracker", module="manager")
@Forwards(value={@Forward(name="selectCourse", path="/manager/specialSeason/selectCourse.jsp"), @Forward(name="listStudents", path="/manager/specialSeason/listStudents.jsp")})
public class SpecialSeasonStatusTrackerDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward selectCourses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SpecialSeasonStatusTrackerBean bean = (SpecialSeasonStatusTrackerBean)this.getRenderedObject();
        if (bean == null) {
            bean = new SpecialSeasonStatusTrackerBean();
        }
        request.setAttribute("bean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("selectCourse");
    }

    public ActionForward updateDepartmentSelection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SpecialSeasonStatusTrackerBean bean = (SpecialSeasonStatusTrackerBean)this.getRenderedObject();
        request.setAttribute("bean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("selectCourse");
    }

    public ActionForward listStudents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SpecialSeasonStatusTrackerBean bean = (SpecialSeasonStatusTrackerBean)this.getRenderedObject();
        bean.clearEntries();
        ArrayList<Enrolment> enrolments = new ArrayList<Enrolment>();
        ArrayList<CompetenceCourse> courses = new ArrayList<CompetenceCourse>();
        ArrayList<Department> departments = new ArrayList<Department>();
        if (this.getDepartment() == null) {
            departments.addAll(Bennu.getInstance().getDepartmentsSet());
        } else {
            departments.add(this.getDepartment());
        }
        for (Department department : departments) {
            if (bean.getCompetenceCourse() == null) {
                courses.addAll(department.getBolonhaCompetenceCourses());
            } else {
                courses.add(bean.getCompetenceCourse());
            }
            for (CompetenceCourse competence : courses) {
                for (CurricularCourse course : competence.getAssociatedCurricularCoursesSet()) {
                    for (Enrolment enrolment : course.getActiveEnrollments(bean.getExecutionSemester())) {
                        if (!enrolment.isSpecialSeason()) continue;
                        enrolments.add(enrolment);
                        bean.addEntry(enrolment.getRegistration().getNumber(), enrolment.getRegistration().getPerson().getName(), enrolment.getRegistration().getDegree().getSigla(), enrolment.getCurricularCourse().getName(bean.getExecutionSemester()));
                    }
                }
            }
            courses.clear();
        }
        bean.setEnrolments(enrolments);
        Collections.sort(bean.getEntries(), SpecialSeasonStatusTrackerRegisterBean.COMPARATOR_STUDENT_NUMBER);
        request.setAttribute("bean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("listStudents");
    }

    public ActionForward exportXLS(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SpecialSeasonStatusTrackerBean bean = (SpecialSeasonStatusTrackerBean)this.getRenderedObject();
        Spreadsheet spreadsheet = this.generateSpreadsheet(bean);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + this.getFilename(bean) + ".xls");
        spreadsheet.exportToXLSSheet((OutputStream)response.getOutputStream());
        response.getOutputStream().flush();
        response.flushBuffer();
        return null;
    }

    private String getFilename(SpecialSeasonStatusTrackerBean bean) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"special.season.filename", (String[])new String[0]));
        if (bean.getCompetenceCourse() != null) {
            strBuilder.append("_");
            strBuilder.append(bean.getCompetenceCourse().getAcronym());
        } else if (this.getDepartment() != null) {
            strBuilder.append("_");
            strBuilder.append(bean.getDepartment().getAcronym());
        }
        strBuilder.append("_");
        strBuilder.append(bean.getExecutionSemester().getSemester());
        strBuilder.append("_");
        strBuilder.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"special.season.semester", (String[])new String[0]));
        strBuilder.append("_");
        strBuilder.append(bean.getExecutionSemester().getExecutionYear().getName());
        return strBuilder.toString();
    }

    private Spreadsheet generateSpreadsheet(SpecialSeasonStatusTrackerBean bean) {
        Spreadsheet spreadsheet = this.createSpreadSheet();
        for (Enrolment enrolment : bean.getEnrolments()) {
            Spreadsheet.Row row = spreadsheet.addRow();
            row.setCell(enrolment.getRegistration().getPerson().getUsername());
            row.setCell(enrolment.getRegistration().getNumber());
            row.setCell(enrolment.getRegistration().getPerson().getName());
            row.setCell(enrolment.getRegistration().getPerson().getInstitutionalOrDefaultEmailAddressValue());
            row.setCell(enrolment.getRegistration().getDegree().getSigla());
            row.setCell(enrolment.getRegistration().getStudentCurricularPlan(bean.getExecutionSemester()).getName());
            row.setCell(enrolment.getCurricularCourse().getAcronym());
            row.setCell(enrolment.getCurricularCourse().getName());
        }
        return spreadsheet;
    }

    private Spreadsheet createSpreadSheet() {
        Spreadsheet spreadsheet = new Spreadsheet(BundleUtil.getString((String)"resources.ApplicationResources", (String)"list.students", (String[])new String[0]));
        spreadsheet.setHeaders(new String[]{BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.username", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.number", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.name", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.email", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.Degree", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curricularPlan", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curricular.course.name", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curricular.course.name", (String[])new String[0]), " ", " "});
        return spreadsheet;
    }

    protected Department getDepartment() {
        SpecialSeasonStatusTrackerBean bean = (SpecialSeasonStatusTrackerBean)this.getRenderedObject();
        if (bean != null && bean.getDepartment() != null) {
            return bean.getDepartment();
        }
        return null;
    }
}

