/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.externalSupervision.consult;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.ui.struts.action.externalSupervision.consult.ExternalSupervisorViewStudentDA;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.thesis.ScientificCouncilManageThesisDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/viewDissertation", module="externalSupervision", functionality=ExternalSupervisorViewStudentDA.class)
@Forwards(value={@Forward(name="chooseDissertation", path="/externalSupervision/consult/chooseDissertation.jsp"), @Forward(name="view-thesis", path="/externalSupervision/consult/showDissertation.jsp")})
public class ShowThesisStatus
extends ScientificCouncilManageThesisDA {
    public static boolean hasDissertations(Student student) {
        HashSet<DegreeCurricularPlan> degreeCurricularPlans = new HashSet<DegreeCurricularPlan>();
        for (Registration registration : student.getRegistrationsSet()) {
            degreeCurricularPlans.addAll(registration.getDegreeCurricularPlans());
        }
        for (DegreeCurricularPlan degreeCurricularPlan : degreeCurricularPlans) {
            if (student.getDissertationEnrolments(degreeCurricularPlan).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static Set<Enrolment> getDissertations(Student student) {
        HashSet<Enrolment> theses = new HashSet<Enrolment>();
        HashSet<DegreeCurricularPlan> degreeCurricularPlans = new HashSet<DegreeCurricularPlan>();
        for (Registration registration : student.getRegistrationsSet()) {
            degreeCurricularPlans.addAll(registration.getDegreeCurricularPlans());
        }
        for (DegreeCurricularPlan degreeCurricularPlan : degreeCurricularPlans) {
            for (Enrolment enrolment : student.getDissertationEnrolments(degreeCurricularPlan)) {
                theses.add(enrolment);
            }
        }
        return theses;
    }

    public ActionForward chooseDissertation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String personId = request.getParameter("personId");
        Person personStudent = (Person)FenixFramework.getDomainObject((String)personId);
        Student student = personStudent.getStudent();
        Set<Enrolment> dissertations = ShowThesisStatus.getDissertations(student);
        request.setAttribute("student", (Object)student);
        request.setAttribute("dissertations", dissertations);
        return mapping.findForward("chooseDissertation");
    }

    public ActionForward viewThesisForSupervisor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = (Thesis)((Object)this.getDomainObject(request, "thesisID"));
        Student student = thesis.getStudent();
        request.setAttribute("student", (Object)student);
        return this.viewThesis(mapping, form, request, response);
    }
}

