/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.directiveCouncil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.report.GratuityReportingService;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.directiveCouncil.DirectiveCouncilApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.LocalDate;

@StrutsFunctionality(app=DirectiveCouncilApplication.class, path="gratuity-reports", titleKey="label.directiveCouncil.gratuityReports")
@Mapping(path="/gratuityReports", module="directiveCouncil")
@Forwards(value={@Forward(name="showReport", path="/directiveCouncil/gratuityReports/showReport.jsp")})
public class GratuityReportsDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward showReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GratuityReportParametersBean parametersBean = this.getGratuityReportParameters() != null ? this.getGratuityReportParameters() : new GratuityReportParametersBean(ExecutionYear.readCurrentExecutionYear());
        request.setAttribute("reportParameters", (Object)parametersBean);
        request.setAttribute("report", (Object)new GratuityReportingService().createGratuityReport(parametersBean.getExecutionYear(), parametersBean.getStartDate(), parametersBean.getEndDate(), parametersBean.getDegreeTypes()));
        return mapping.findForward("showReport");
    }

    public ActionForward showReportInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("reportParameters", this.getRenderedObject());
        GratuityReportParametersBean parametersBean = this.getGratuityReportParameters() != null ? this.getGratuityReportParameters() : new GratuityReportParametersBean(ExecutionYear.readCurrentExecutionYear());
        request.setAttribute("report", (Object)new GratuityReportingService().createGratuityReport(parametersBean.getExecutionYear(), parametersBean.getStartDate(), parametersBean.getEndDate(), parametersBean.getDegreeTypes()));
        return mapping.findForward("showReport");
    }

    private GratuityReportParametersBean getGratuityReportParameters() {
        return (GratuityReportParametersBean)this.getRenderedObject("reportParameters");
    }

    public static class GratuityReportParametersBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ExecutionYear executionYear;
        private LocalDate startDate;
        private LocalDate endDate;
        private Boolean detailed;
        private List<DegreeType> degreeTypes;

        public GratuityReportParametersBean(ExecutionYear executionYear) {
            this.setExecutionYear(executionYear);
            this.setDetailed(false);
            this.degreeTypes = new ArrayList<DegreeType>();
        }

        public ExecutionYear getExecutionYear() {
            return this.executionYear;
        }

        public void setExecutionYear(ExecutionYear executionYear) {
            this.executionYear = executionYear;
        }

        public LocalDate getStartDate() {
            return this.startDate;
        }

        public void setStartDate(LocalDate startDate) {
            this.startDate = startDate;
        }

        public LocalDate getEndDate() {
            return this.endDate;
        }

        public void setEndDate(LocalDate endDate) {
            this.endDate = endDate;
        }

        public Boolean getDetailed() {
            return this.detailed;
        }

        public void setDetailed(Boolean detailed) {
            this.detailed = detailed;
        }

        public List<DegreeType> getDegreeTypes() {
            return this.degreeTypes;
        }

        public void setDegreeTypes(List<DegreeType> degreeTypes) {
            this.degreeTypes = degreeTypes;
        }
    }
}

