/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator.thesis;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.ManageThesisContext;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/thesisProcess", module="coordinator", functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="showInformation", path="/coordinator/thesis/showInformation.jsp")})
public class ThesisProcessDA
extends FenixDispatchAction {
    public ActionForward showInformation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ManageThesisContext manageThesisContext = this.processContext(request);
        return mapping.findForward("showInformation");
    }

    private ManageThesisContext processContext(HttpServletRequest request) {
        ExecutionDegree executionDegree;
        ManageThesisContext manageThesisContext = (ManageThesisContext)this.getRenderedObject();
        if (manageThesisContext == null && (executionDegree = this.guessExecutionDegree(request)) != null) {
            manageThesisContext = new ManageThesisContext(executionDegree);
        }
        if (manageThesisContext != null) {
            request.setAttribute("manageThesisContext", (Object)manageThesisContext);
        }
        return manageThesisContext;
    }

    private ExecutionDegree guessExecutionDegree(HttpServletRequest request) {
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)((Object)this.getDomainObject(request, "degreeCurricularPlanID"));
        ExecutionDegree last = null;
        if (degreeCurricularPlan != null) {
            for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                ExecutionYear executionYear = executionDegree.getExecutionYear();
                if (executionYear.isCurrent()) {
                    return executionDegree;
                }
                if (last != null && !last.getExecutionYear().isBefore(executionYear)) continue;
                last = executionDegree;
            }
        }
        return last;
    }
}

