/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator.student.curriculum;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="coordinator", path="/viewStudentCurriculumSearch", formBean="viewStudentCurriculumForm", functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="chooseStudent", path="/coordinator/student/curriculum/chooseStudent.jsp"), @Forward(name="chooseCurriculumType", path="/coordinator/student/curriculum/chooseCurriculumType.jsp")})
public class ViewStudentCurriculumDA
extends FenixDispatchAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setDegreeCurricularPlanId(form, this.getDegreeCurricularPlanId(request));
        this.setExecutionDegreeId(form, this.getExecutionDegreeId(request));
        return mapping.findForward("chooseStudent");
    }

    public ActionForward showStudentCurriculum(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Student student = this.getStudent(actionForm);
        if (student == null) {
            this.addActionMessage(request, "label.coordinator.viewStudentCurriculum.noStudent");
            return mapping.findForward("chooseStudent");
        }
        if (!this.getDegreeCurricularPlan(actionForm).isBolonhaDegree()) {
            if (!student.hasTransitionRegistrations()) {
                return this.getOldCurriculumRedirect(actionForm, student);
            }
            request.setAttribute("student", (Object)student);
            return mapping.findForward("chooseCurriculumType");
        }
        return this.getOldCurriculumRedirect(actionForm, student);
    }

    private ActionForward getOldCurriculumRedirect(ActionForm actionForm, Student student) {
        ActionForward actionForward = new ActionForward();
        actionForward.setPath("/viewStudentCurriculum.do?method=prepareReadByStudentNumber&studentNumber=" + student.getNumber() + "&executionDegreeId=" + this.getExecutionDegreeId(actionForm) + "&degreeCurricularPlanID=" + this.getDegreeCurricularPlanId(actionForm));
        return actionForward;
    }

    private String getExecutionDegreeId(HttpServletRequest request) {
        return request.getParameter("executionDegreeId");
    }

    private String getExecutionDegreeId(ActionForm actionForm) {
        return (String)((DynaActionForm)actionForm).get("executionDegreeId");
    }

    private void setExecutionDegreeId(ActionForm actionForm, String id) {
        ((DynaActionForm)actionForm).set("executionDegreeId", (Object)id);
    }

    private DegreeCurricularPlan getDegreeCurricularPlan(ActionForm form) {
        return (DegreeCurricularPlan)FenixFramework.getDomainObject((String)this.getDegreeCurricularPlanId(form));
    }

    private String getDegreeCurricularPlanId(HttpServletRequest request) {
        return request.getParameter("degreeCurricularPlanID");
    }

    private void setDegreeCurricularPlanId(ActionForm actionForm, String id) {
        ((DynaActionForm)actionForm).set("degreeCurricularPlanId", (Object)id);
    }

    private String getDegreeCurricularPlanId(ActionForm actionForm) {
        return (String)((DynaActionForm)actionForm).get("degreeCurricularPlanId");
    }

    private Student getStudent(ActionForm actionForm) {
        String studentNumberString = ((DynaActionForm)actionForm).getString("studentNumber");
        if (!StringUtils.isEmpty((String)studentNumberString) && NumberUtils.isNumber((String)studentNumberString)) {
            return Student.readStudentByNumber(Integer.valueOf(studentNumberString));
        }
        return null;
    }
}

