/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidate;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.CandidacyDocument;
import org.fenixedu.academic.dto.candidacy.CandidacyDocumentUploadBean;
import org.fenixedu.academic.service.services.administrativeOffice.candidacy.SaveCandidacyDocumentFiles;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.candidate.CandidateApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=CandidateApplication.CandidateCandidaciesApp.class, titleKey="link.candidacies", path="view-candidacies")
@Mapping(module="candidate", path="/viewCandidacies", formBean="candidacyForm")
@Forwards(value={@Forward(name="uploadDocuments", path="/candidate/uploadDocuments.jsp"), @Forward(name="viewDetail", path="/candidate/viewCandidacyDetails.jsp"), @Forward(name="view", path="/candidate/viewCandidacies.jsp")})
public class ViewCandidaciesDispatchAction
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("view");
    }

    public ActionForward viewDetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Candidacy candidacy = this.getCandidacy(request);
        request.setAttribute("canChangePersonalData", (Object)candidacy.getActiveCandidacySituation().canChangePersonalData());
        request.setAttribute("candidacy", (Object)candidacy);
        return mapping.findForward("viewDetail");
    }

    private Candidacy getCandidacy(HttpServletRequest request) {
        String candidacyID = request.getParameter("candidacyID");
        for (Candidacy candidacy : ViewCandidaciesDispatchAction.getUserView(request).getPerson().getCandidaciesSet()) {
            if (!candidacy.getExternalId().equals(candidacyID)) continue;
            return candidacy;
        }
        return null;
    }

    public ActionForward prepareUploadDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.fillRequest(request, this.getCandidacy(request));
        return mapping.findForward("uploadDocuments");
    }

    public ActionForward uploadDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        List beans = (List)RenderUtils.getViewState((String)"candidacyDocuments").getMetaObject().getObject();
        for (CandidacyDocumentUploadBean bean : beans) {
            bean.createTemporaryFile();
        }
        SaveCandidacyDocumentFiles.run(beans);
        for (CandidacyDocumentUploadBean bean : beans) {
            bean.deleteTemporaryFile();
        }
        this.fillRequest(request, this.getCandidacy(beans));
        return mapping.findForward("uploadDocuments");
    }

    private void fillRequest(HttpServletRequest request, Candidacy candidacy) {
        if (RenderUtils.getViewState((String)"candidacyDocuments") != null) {
            RenderUtils.invalidateViewState((String)"candidacyDocuments");
        }
        ArrayList<CandidacyDocumentUploadBean> candidacyDocuments = new ArrayList<CandidacyDocumentUploadBean>();
        for (CandidacyDocument candidacyDocument : candidacy.getCandidacyDocumentsSet()) {
            candidacyDocuments.add(new CandidacyDocumentUploadBean(candidacyDocument));
        }
        request.setAttribute("candidacyDocuments", candidacyDocuments);
        request.setAttribute("candidacy", (Object)candidacy);
    }

    private Candidacy getCandidacy(List<CandidacyDocumentUploadBean> beans) {
        if (!beans.isEmpty()) {
            return beans.iterator().next().getCandidacyDocument().getCandidacy();
        }
        return null;
    }
}

