/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.alumni;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.EducationArea;
import org.fenixedu.academic.domain.Formation;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.alumni.formation.AlumniFormation;
import org.fenixedu.academic.dto.alumni.formation.AlumniFormationBean;
import org.fenixedu.academic.service.services.alumni.CreateFormation;
import org.fenixedu.academic.service.services.alumni.EditFormation;
import org.fenixedu.academic.service.services.person.qualification.DeleteQualification;
import org.fenixedu.academic.ui.struts.action.alumni.AlumniApplication;
import org.fenixedu.academic.ui.struts.action.alumni.AlumniEntityManagementDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=AlumniApplication.AlumniFormationApp.class, path="formation", titleKey="link.graduate.education")
@Mapping(module="alumni", path="/formation")
@Forwards(value={@Forward(name="alumniCreateFormation", path="/alumni/alumniManageFormation.jsp"), @Forward(name="alumniEditFormation", path="/alumni/alumniManageFormation.jsp"), @Forward(name="viewAlumniQualifications", path="/alumni/viewAlumniQualifications.jsp")})
public class AlumniFormationManagementDA
extends AlumniEntityManagementDA {
    public ActionForward initFormationManagement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("alumniFormationBean", (Object)new AlumniFormationBean(this.getAlumniFromLoggedPerson(request)));
        return mapping.findForward("viewAlumniQualifications");
    }

    @EntryPoint
    public ActionForward innerFormationManagement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("educationFormationList", this.getAlumniFromLoggedPerson(request).getFormations());
        return mapping.findForward("viewAlumniQualifications");
    }

    public ActionForward initFormationCreation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("alumniFormation", (Object)new AlumniFormation());
        request.setAttribute("formationUpdate", (Object)"true");
        return mapping.findForward("alumniCreateFormation");
    }

    public ActionForward updateAlumniFormationTypePostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("alumniFormation", this.getObjectFromViewState("alumniFormation"));
        AlumniFormation formationInfo = (AlumniFormation)this.getObjectFromViewState("alumniFormationDegree");
        formationInfo.updateTypeSchema();
        RenderUtils.invalidateViewState((String)"alumniFormationDegree");
        request.setAttribute("alumniFormationDegree", (Object)formationInfo);
        request.setAttribute("formationEducationArea", this.getFromRequest(request, "formationEducationArea"));
        request.setAttribute("formationUpdate", (Object)"true");
        return mapping.findForward("alumniCreateFormation");
    }

    public ActionForward updateAlumniFormationInfoPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("alumniFormation", this.getObjectFromViewState("alumniFormation"));
        AlumniFormation formationInfo = (AlumniFormation)this.getObjectFromViewState("alumniFormationInstitution");
        formationInfo.updateInstitutionSchema();
        RenderUtils.invalidateViewState((String)"alumniFormationInstitution");
        request.setAttribute("alumniFormationInstitution", (Object)formationInfo);
        request.setAttribute("formationEducationArea", this.getFromRequest(request, "formationEducationArea"));
        request.setAttribute("formationUpdate", (Object)"true");
        return mapping.findForward("alumniCreateFormation");
    }

    public ActionForward manageAlumniQualification(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AlumniFormation formationInfo = (AlumniFormation)this.getObjectFromViewState("alumniFormation");
        formationInfo.setEducationArea((EducationArea)((Object)this.getDomainObject(request, "formationEducationArea")));
        try {
            if (formationInfo.hasAssociatedFormation()) {
                EditFormation.runEditFormation(formationInfo);
            } else {
                CreateFormation.runCreateFormation(this.getAlumniFromLoggedPerson(request), formationInfo);
            }
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
            request.setAttribute("alumniFormation", this.getObjectFromViewState("alumniFormation"));
            request.setAttribute("alumniFormationDegree", this.getObjectFromViewState("alumniFormationDegree"));
            request.setAttribute("alumniFormationInstitution", this.getObjectFromViewState("alumniFormationInstitution"));
            request.setAttribute("formationEducationArea", this.getFromRequest(request, "formationEducationArea"));
            request.setAttribute("formationUpdate", (Object)"true");
            return mapping.findForward("alumniCreateFormation");
        }
        return this.innerFormationManagement(mapping, actionForm, request, response);
    }

    public ActionForward prepareFormationEdit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("formationUpdate", (Object)"true");
        return this.getFormation(mapping, request);
    }

    private ActionForward getFormation(ActionMapping mapping, HttpServletRequest request) {
        Qualification qualification = (Qualification)((Object)this.getDomainObject(request, "formationId"));
        AlumniFormation formation = AlumniFormation.buildFrom((Formation)((Object)qualification));
        request.setAttribute("formationEducationArea", (Object)formation.getEducationArea().getExternalId());
        request.setAttribute("alumniFormation", (Object)formation);
        return mapping.findForward("alumniEditFormation");
    }

    public ActionForward deleteFormation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.getFromRequest(request, "cancel") == null) {
            try {
                DeleteQualification.runDeleteQualification(this.getFromRequest(request, "formationId").toString());
            }
            catch (DomainException e) {
                this.addActionMessage(request, e.getKey(), e.getArgs());
            }
        }
        return this.innerFormationManagement(mapping, actionForm, request, response);
    }
}

