/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment.bolonha.validators;

import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class GradeValidator
extends HtmlValidator {
    private boolean required = false;

    public GradeValidator() {
        this.setMessage("renderers.validator.grade");
        this.setKey(true);
    }

    public GradeValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
        this.setMessage("renderers.validator.grade");
        this.setKey(true);
    }

    public void performValidation() {
        String grade = this.getComponent().getValue();
        if (this.isRequired() && (grade == null || grade.length() == 0)) {
            this.setValid(false);
            this.setKey(true);
            this.setMessage("renderers.validator.required");
        } else if (grade == null || grade.length() == 0 || grade.equalsIgnoreCase("NA") || grade.equalsIgnoreCase("RE") || grade.equalsIgnoreCase("AP") || grade.equalsIgnoreCase("APT")) {
            this.setValid(true);
        } else {
            try {
                Integer integer = Integer.valueOf(grade);
                if (integer >= 10 && integer <= 20 || integer >= 0 && integer <= 5) {
                    this.setValid(true);
                } else {
                    this.setValid(false);
                }
            }
            catch (NumberFormatException e) {
                this.setValid(false);
            }
        }
    }

    protected String getResourceMessage(String message) {
        return RenderUtils.getFormatedResourceString((String)message, (Object[])new Object[]{this.getComponent().getValue()});
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

