/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroupType;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.StudentStandaloneEnrolmentBean;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment.NoCourseGroupCurriculumGroupEnrolmentsDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/studentStandaloneEnrolments", module="academicAdministration", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="showExtraEnrolments", path="/academicAdminOffice/showNoCourseGroupCurriculumGroupEnrolments.jsp"), @Forward(name="chooseExtraEnrolment", path="/academicAdminOffice/chooseNoCourseGroupCurriculumGroupEnrolment.jsp"), @Forward(name="showDegreeModulesToEnrol", path="/academicAdministration/studentEnrolments.do?method=prepareFromExtraEnrolment")})
public class StudentStandaloneEnrolmentsDA
extends NoCourseGroupCurriculumGroupEnrolmentsDA {
    @Override
    protected StudentStandaloneEnrolmentBean createNoCourseGroupEnrolmentBean(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        return new StudentStandaloneEnrolmentBean(studentCurricularPlan, executionSemester);
    }

    @Override
    protected String getActionName() {
        return "studentStandaloneEnrolments";
    }

    @Override
    protected NoCourseGroupCurriculumGroupType getGroupType() {
        return NoCourseGroupCurriculumGroupType.STANDALONE;
    }

    @Override
    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExecutionSemester semester = this.getExecutionSemester(request);
        if (this.isStudentInPartialRegime(request, semester)) {
            this.addActionMessage("error", request, "error.Student.has.partial.regime", semester.getQualifiedName());
        }
        return super.prepare(mapping, actionForm, request, response);
    }

    private void chooseCurricular(HttpServletRequest request, CurricularRuleLevel level) {
        StudentStandaloneEnrolmentBean bean = (StudentStandaloneEnrolmentBean)this.getNoCourseGroupEnrolmentBean();
        bean.setCurricularRuleLevel(level);
        request.setAttribute("enrolmentBean", (Object)bean);
        RenderUtils.invalidateViewState();
    }

    @Override
    public ActionForward chooseCurricular(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.chooseCurricular(request, CurricularRuleLevel.STANDALONE_ENROLMENT);
        return mapping.findForward("chooseExtraEnrolment");
    }

    public ActionForward chooseCurricularWithoutRules(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.chooseCurricular(request, CurricularRuleLevel.STANDALONE_ENROLMENT_NO_RULES);
        return mapping.findForward("chooseExtraEnrolment");
    }

    private boolean isStudentInPartialRegime(HttpServletRequest request, ExecutionSemester semester) {
        return this.getStudentCurricularPlan(request).getRegistration().isPartialRegime(semester.getExecutionYear());
    }
}

