/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.interfaces.HasExecutionDegree;
import org.fenixedu.academic.util.MultiLanguageString;

public class ExecutionCourseManagementBean
implements Serializable,
HasExecutionDegree {
    private static final long serialVersionUID = 1L;
    private ExecutionSemester semester;
    private String acronym;
    private String name;
    private EntryPhase entryPhase;
    private String comments;
    private List<CurricularCourse> curricularCourseList;
    private DegreeCurricularPlan degreeCurricularPlan;
    private ExecutionCourse executionCourse;
    private CurricularYear curricularYear;

    public ExecutionCourseManagementBean(ExecutionSemester semester) {
        this.setSemester(semester);
        this.setCurricularCourseList(new ArrayList<CurricularCourse>());
    }

    public ExecutionCourseManagementBean(ExecutionSemester semester, CurricularCourse curricularCourse) {
        this.setSemester(semester);
        this.setCurricularCourseList(new ArrayList<CurricularCourse>());
        this.getCurricularCourseList().add(curricularCourse);
        this.setName(curricularCourse.getNameI18N().getContent(MultiLanguageString.pt));
    }

    public ExecutionCourseManagementBean(ExecutionCourse executionCourse) {
        this.setExecutionCourse(executionCourse);
    }

    public ExecutionCourseManagementBean(DegreeCurricularPlan degreeCurricularPlan) {
        this.setDegreeCurricularPlan(degreeCurricularPlan);
    }

    public ExecutionCourseManagementBean() {
    }

    public String getAcronym() {
        return this.acronym;
    }

    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    public EntryPhase getEntryPhase() {
        return this.entryPhase;
    }

    public void setEntryPhase(EntryPhase entryPhase) {
        this.entryPhase = entryPhase;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExecutionCourse getExecutionCourse() {
        return this.executionCourse;
    }

    public void setExecutionCourse(ExecutionCourse executionCourse) {
        this.executionCourse = executionCourse;
    }

    public ExecutionSemester getSemester() {
        return this.semester;
    }

    public void setSemester(ExecutionSemester semester) {
        this.semester = semester;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlan;
    }

    public void setDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        this.degreeCurricularPlan = degreeCurricularPlan;
    }

    public List<CurricularCourse> getCurricularCourseList() {
        return this.curricularCourseList;
    }

    public void setCurricularCourseList(List<CurricularCourse> curricularCourseList) {
        this.curricularCourseList = curricularCourseList;
    }

    public CurricularYear getCurricularYear() {
        return this.curricularYear;
    }

    public void setCurricularYear(CurricularYear curricularYear) {
        this.curricularYear = curricularYear;
    }

    @Override
    public ExecutionDegree getExecutionDegree() {
        if (this.semester != null && this.degreeCurricularPlan != null) {
            ExecutionDegree degree = this.degreeCurricularPlan.getExecutionDegreeByAcademicInterval(this.semester.getAcademicInterval());
            return degree;
        }
        return null;
    }
}

