/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.teacher.authorization;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.TeacherAuthorization;
import org.fenixedu.academic.domain.TeacherCategory;
import org.fenixedu.academic.ui.spring.controller.AcademicAdministrationSpringApplication;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.AuthorizationService;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.CategoryBean;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.FormBean;
import org.fenixedu.academic.ui.spring.controller.teacher.authorization.SearchBean;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=AcademicAdministrationSpringApplication.class, title="teacher.authorizations.title", accessGroup="academic(MANAGE_TEACHER_AUTHORIZATIONS)")
@RequestMapping(value={"/teacher/authorizations"})
public class AuthorizationController {
    @Autowired
    AuthorizationService service;

    private String view(String string) {
        return "fenixedu-academic/teacher/authorization/" + string;
    }

    private String redirectHome(SearchBean search, RedirectAttributes attrs) {
        attrs.addAttribute("department", search.getDepartment() == null ? null : search.getDepartment().getExternalId());
        attrs.addAttribute("period", (Object)search.getPeriod().getExternalId());
        return "redirect:/teacher/authorizations";
    }

    @RequestMapping(method={RequestMethod.GET})
    public String home(Model model, @ModelAttribute FormBean search) {
        if (search.getPeriod() == null) {
            search.setPeriod(this.service.getCurrentPeriod());
        }
        model.addAttribute("search", (Object)search);
        model.addAttribute("departments", this.service.getDepartments());
        model.addAttribute("periods", this.service.getExecutionPeriods());
        model.addAttribute("authorizations", this.service.searchAuthorizations(search));
        return this.view("show");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"categories"})
    public String categories(Model model) {
        model.addAttribute("categories", this.service.getCategories());
        return this.view("categories/show");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"categories/create"})
    public String showCreate(Model model) {
        model.addAttribute("form", (Object)new CategoryBean());
        return this.view("categories/create");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"categories/{category}"})
    public String showEdit(Model model, @PathVariable TeacherCategory category) {
        model.addAttribute("form", (Object)category);
        return this.view("categories/create");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"categories/{category}"})
    public String createOrEdit(Model model, @Value(value="null") @PathVariable TeacherCategory category, @ModelAttribute CategoryBean form) {
        try {
            if (category != null) {
                this.service.editCategory(category, form);
            } else {
                this.service.createCategory(form);
            }
        }
        catch (Exception e) {
            model.addAttribute("error", (Object)e.getLocalizedMessage());
            model.addAttribute("form", (Object)form);
            return this.view("categories/create");
        }
        return "redirect:/teacher/authorizations/categories";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"download"})
    public String download(Model model, @ModelAttribute SearchBean search, RedirectAttributes attrs, HttpServletResponse response) throws IOException {
        response.setContentType("text/csv");
        response.setHeader("Content-Disposition", "filename=" + this.service.getCsvFilename(search));
        this.service.dumpCSV(search, (OutputStream)response.getOutputStream());
        response.flushBuffer();
        return this.redirectHome(search, attrs);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"upload"})
    public String showUpload(Model model) {
        model.addAttribute("currentUser", (Object)Authenticate.getUser());
        model.addAttribute("categories", this.service.getCategories());
        model.addAttribute("departments", this.service.getDepartments());
        model.addAttribute("periods", this.service.getExecutionPeriods());
        return this.view("upload");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"upload"})
    public String upload(Model model, @RequestParam ExecutionSemester period, @RequestParam MultipartFile csv) {
        try {
            List<TeacherAuthorization> imported = this.service.importCSV(period, csv);
            model.addAttribute("authorizations", imported);
        }
        catch (RuntimeException re) {
            model.addAttribute("error", (Object)re.getLocalizedMessage());
        }
        return this.view("upload-finished");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"create"})
    public String showCreate(Model model, @Value(value="null") @ModelAttribute FormBean search) {
        if (search.getPeriod() == null) {
            search.setPeriod(this.service.getExecutionPeriods().isEmpty() ? null : this.service.getExecutionPeriods().get(0));
        }
        model.addAttribute("formBean", (Object)search);
        model.addAttribute("departments", this.service.getDepartments());
        model.addAttribute("periods", this.service.getExecutionPeriods());
        model.addAttribute("categories", this.service.getCategories());
        return this.view("create");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"create"})
    public String create(Model model, @ModelAttribute FormBean form, RedirectAttributes attrs) {
        this.service.createTeacherAuthorization(form);
        return this.redirectHome(form, attrs);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"revoked"})
    public String revoked(Model model) {
        model.addAttribute("authorizations", this.service.getRevokedAuthorizations());
        return this.view("revoked");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"{authorization}/revoke"})
    public String revoke(Model model, @PathVariable TeacherAuthorization authorization, @Value(value="null") @ModelAttribute SearchBean search, RedirectAttributes attrs) {
        this.service.revoke(authorization);
        return this.redirectHome(search, attrs);
    }

    private String redirectHome(FormBean search, RedirectAttributes attrs) {
        attrs.addAttribute("department", search.getDepartment() == null ? null : search.getDepartment().getExternalId());
        attrs.addAttribute("period", (Object)search.getPeriod().getExternalId());
        return "redirect:/teacher/authorizations";
    }
}

