/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.teacher;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.portal.servlet.PortalLayoutInjector;
import org.springframework.web.servlet.view.JstlView;

public class TeacherView
extends JstlView {
    private final ExecutionCourse executionCourse;
    private final String page;

    public TeacherView(String page, ExecutionCourse executionCourse) {
        this.page = page;
        this.executionCourse = executionCourse;
    }

    protected void exposeHelpers(HttpServletRequest request) throws Exception {
        this.setServletContext(request.getServletContext());
        super.exposeHelpers(request);
        Professorship professorship = this.executionCourse.getProfessorship(AccessControl.getPerson());
        HashMap<String, Object> requestContext = new HashMap<String, Object>();
        requestContext.put("professorship", (Object)professorship);
        requestContext.put("executionCourse", (Object)this.executionCourse);
        PortalLayoutInjector.addContextExtension(requestContext);
    }

    public String getUrl() {
        return "/teacher/" + this.page + ".jsp";
    }
}

