/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.validators;

import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class DateTimeValidator
extends HtmlValidator {
    private boolean required;

    public DateTimeValidator() {
        this.setKey(true);
    }

    public DateTimeValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
        this.setKey(true);
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void performValidation() {
        HtmlSimpleValueComponent component = (HtmlSimpleValueComponent)this.getComponent();
        String value = component.getValue();
        if (value == null || value.length() == 0) {
            this.setMessage("renderers.validator.dateTime.required");
            this.setValid(!this.isRequired());
        } else if (value.equals("invalid")) {
            this.setMessage("renderers.validator.dateTime.invalid");
            this.setValid(false);
        } else if (value.equals("incomplete")) {
            this.setMessage("renderers.validator.dateTime.incomplete");
            this.setValid(false);
        } else {
            int indexOfT = value.indexOf(84);
            String[] dateParts = value.substring(0, indexOfT).split("-");
            String[] timeParts = value.substring(indexOfT + 1).split(":");
            try {
                int year = Integer.valueOf(dateParts[0]);
                if (year < 1000 || year > 9999) {
                    this.setMessage("renderers.validator.dateTime.invalid");
                    this.setValid(false);
                } else {
                    int hours = Integer.parseInt(timeParts[0]);
                    int minutes = Integer.parseInt(timeParts[1]);
                    if (this.inRange(hours, 0, 23) && this.inRange(minutes, 0, 59)) {
                        this.setValid(true);
                    } else {
                        this.setMessage("renderers.validator.dateTime.notInRange");
                        this.setValid(false);
                    }
                }
            }
            catch (NumberFormatException e) {
                this.setMessage("renderers.validator.dateTime.notNumbers");
                this.setValid(false);
            }
        }
    }

    private boolean inRange(int value, int min, int max) {
        return value >= min && value <= max;
    }
}

