/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.htmlEditor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.tidy.Tidy;
import org.w3c.tidy.TidyMessage;
import org.w3c.tidy.TidyMessageListener;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public abstract class TidyConverter
extends Converter {
    private static final Logger logger = LoggerFactory.getLogger(TidyConverter.class);
    public static final String TIDY_PROPERTIES = "/HtmlEditor-Tidy.properties";
    private static final String ENCODING = Charset.defaultCharset().name();

    public String getTidyProperties() {
        return TIDY_PROPERTIES;
    }

    public Object convert(Class type, Object value) {
        String htmlText = (String)value;
        if (htmlText == null || htmlText.length() == 0) {
            return null;
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(htmlText.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Tidy tidy = this.createTidyParser();
        TidyErrorsListener errorListener = new TidyErrorsListener();
        tidy.setMessageListener((TidyMessageListener)errorListener);
        Document document = tidy.parseDOM((InputStream)inStream, null);
        if (errorListener.isBogus()) {
            throw new ConversionException("renderers.converter.safe.invalid");
        }
        this.parseDocument(outStream, tidy, document);
        try {
            return this.filterOutput(new String(outStream.toByteArray(), ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ConversionException("tidy.converter.ending.notSupported.critical");
        }
    }

    protected String filterOutput(String output) {
        return output;
    }

    private Tidy createTidyParser() {
        Tidy tidy = new Tidy();
        Properties properties = new Properties();
        try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(this.getTidyProperties());){
            properties.load(stream);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        tidy.setConfigurationFromProps(properties);
        return tidy;
    }

    protected abstract void parseDocument(OutputStream var1, Tidy var2, Document var3);

    private static class TidyErrorsListener
    implements TidyMessageListener {
        boolean bogus;

        private TidyErrorsListener() {
        }

        public boolean isBogus() {
            return this.bogus;
        }

        public void setBogus(boolean bogus) {
            this.bogus = bogus;
        }

        public void messageReceived(TidyMessage message) {
            if (message.getLevel().equals((Object)TidyMessage.Level.ERROR)) {
                this.setBogus(true);
            }
        }
    }
}

