/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.enrolment.DegreeModuleToEnrol;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.CurriculumModuleBean;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.StudentEnrolmentBean;
import org.fenixedu.academic.ui.renderers.converters.DegreeModuleToEnrolKeyConverter;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixWebFramework.rendererExtensions.controllers.CopyCheckBoxValuesController;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyArrayConverter;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlCheckBox;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlMultipleHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;

public class StudentCurricularPlanEnrolmentsRenderer
extends InputRenderer {
    private Integer initialWidth = 70;
    private Integer widthDecreasePerLevel = 3;
    private String tablesClasses = "showinfo3 mvert0";
    private String groupRowClasses = "bgcolor2";
    private String enrolmentClasses = "smalltxt, smalltxt aright, smalltxt aright, smalltxt aright, aright";
    private String curricularCoursesToEnrol = "smalltxt, smalltxt aright, smalltxt aright, aright";
    private String linkURL;

    public Integer getInitialWidth() {
        return this.initialWidth;
    }

    public void setInitialWidth(Integer initialWidth) {
        this.initialWidth = initialWidth;
    }

    public Integer getWidthDecreasePerLevel() {
        return this.widthDecreasePerLevel;
    }

    public void setWidthDecreasePerLevel(Integer widthDecreasePerLevel) {
        this.widthDecreasePerLevel = widthDecreasePerLevel;
    }

    public String getTablesClasses() {
        return this.tablesClasses;
    }

    public void setTablesClasses(String tablesClasses) {
        this.tablesClasses = tablesClasses;
    }

    public String getGroupRowClasses() {
        return this.groupRowClasses;
    }

    public void setGroupRowClasses(String groupRowClasses) {
        this.groupRowClasses = groupRowClasses;
    }

    private String[] getEnrolmentClasses() {
        return this.enrolmentClasses.split(",");
    }

    public void setEnrolmentClasses(String enrolmentClasses) {
        this.enrolmentClasses = enrolmentClasses;
    }

    private String getEnrolmentNameClasses() {
        return this.getEnrolmentClasses()[0];
    }

    private String getEnrolmentYearClasses() {
        return this.getEnrolmentClasses()[1];
    }

    private String getEnrolmentSemesterClasses() {
        return this.getEnrolmentClasses()[2];
    }

    private String getEnrolmentEctsClasses() {
        return this.getEnrolmentClasses()[3];
    }

    private String getEnrolmentCheckBoxClasses() {
        return this.getEnrolmentClasses()[4];
    }

    private String[] getCurricularCourseClasses() {
        return this.curricularCoursesToEnrol.split(",");
    }

    public void setCurricularCourseClasses(String curricularCoursesToEnrol) {
        this.curricularCoursesToEnrol = curricularCoursesToEnrol;
    }

    private String getCurricularCourseNameClasses() {
        return this.getCurricularCourseClasses()[0];
    }

    private String getCurricularCourseYearClasses() {
        return this.getCurricularCourseClasses()[1];
    }

    private String getCurricularCourseEctsClasses() {
        return this.getCurricularCourseClasses()[2];
    }

    private String getCurricularCourseCheckBoxClasses() {
        return this.getCurricularCourseClasses()[3];
    }

    public String getLinkURL() {
        return this.linkURL;
    }

    public void setLinkURL(String linkURL) {
        this.linkURL = linkURL;
    }

    protected Layout getLayout(Object object, Class type) {
        return new StudentCurricularPlanEnrolmentLayout();
    }

    public static class CurriculumModuleComparator
    implements Comparator<CurriculumModuleBean> {
        private final ExecutionSemester executionSemester;

        public CurriculumModuleComparator(ExecutionSemester executionSemester) {
            this.executionSemester = executionSemester;
        }

        @Override
        public int compare(CurriculumModuleBean o1, CurriculumModuleBean o2) {
            CurriculumGroup c1 = (CurriculumGroup)((Object)o1.getCurriculumModule());
            CurriculumGroup c2 = (CurriculumGroup)((Object)o2.getCurriculumModule());
            return c1.getChildOrder(this.executionSemester).compareTo(c2.getChildOrder(this.executionSemester));
        }
    }

    private class StudentCurricularPlanEnrolmentLayout
    extends Layout {
        private final CopyCheckBoxValuesController enrollmentsController = new CopyCheckBoxValuesController();
        private final CopyCheckBoxValuesController degreeModulesToEnrolController = new CopyCheckBoxValuesController();
        private StudentEnrolmentBean studentEnrolmentBean = null;

        private StudentCurricularPlanEnrolmentLayout() {
        }

        public HtmlComponent createComponent(Object object, Class type) {
            this.studentEnrolmentBean = (StudentEnrolmentBean)object;
            HtmlBlockContainer container = new HtmlBlockContainer();
            if (this.studentEnrolmentBean == null) {
                return new HtmlText();
            }
            HtmlMultipleHiddenField hiddenEnrollments = new HtmlMultipleHiddenField();
            hiddenEnrollments.bind(StudentCurricularPlanEnrolmentsRenderer.this.getInputContext().getMetaObject(), "curriculumModules");
            hiddenEnrollments.setConverter((Converter)new DomainObjectKeyArrayConverter());
            hiddenEnrollments.setController((HtmlController)this.enrollmentsController);
            HtmlMultipleHiddenField hiddenDegreeModulesToEnrol = new HtmlMultipleHiddenField();
            hiddenDegreeModulesToEnrol.bind(StudentCurricularPlanEnrolmentsRenderer.this.getInputContext().getMetaObject(), "degreeModulesToEnrol");
            hiddenDegreeModulesToEnrol.setConverter((Converter)new DegreeModuleToEnrolKeyConverter());
            hiddenDegreeModulesToEnrol.setController((HtmlController)this.degreeModulesToEnrolController);
            container.addChild((HtmlComponent)hiddenEnrollments);
            container.addChild((HtmlComponent)hiddenDegreeModulesToEnrol);
            this.generateModules(container, this.studentEnrolmentBean.getStudentCurricularPlan(), this.studentEnrolmentBean.getCurriculumModuleBean(), this.studentEnrolmentBean.getExecutionPeriod(), 0);
            return container;
        }

        private void generateModules(HtmlBlockContainer blockContainer, StudentCurricularPlan studentCurricularPlan, CurriculumModuleBean curriculumModuleBean, ExecutionSemester executionSemester, int depth) {
            HtmlTable groupTable = new HtmlTable();
            blockContainer.addChild((HtmlComponent)groupTable);
            groupTable.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getTablesClasses());
            groupTable.setStyle("width: " + (StudentCurricularPlanEnrolmentsRenderer.this.getInitialWidth() - depth) + "em; margin-left: " + depth + "em;");
            HtmlTableRow htmlTableRow = groupTable.createRow();
            htmlTableRow.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getGroupRowClasses());
            htmlTableRow.createCell().setBody((HtmlComponent)new HtmlText(curriculumModuleBean.getCurriculumModule().getName().getContent()));
            HtmlTableCell checkBoxCell = htmlTableRow.createCell();
            checkBoxCell.setClasses("aright");
            HtmlCheckBox checkBox = new HtmlCheckBox(true);
            MetaObject enrolmentMetaObject = MetaObjectFactory.createObject((Object)((Object)curriculumModuleBean.getCurriculumModule()), (Schema)new Schema(CurriculumGroup.class));
            checkBox.setName("enrolmentCheckBox" + curriculumModuleBean.getCurriculumModule().getExternalId());
            checkBox.setUserValue(enrolmentMetaObject.getKey().toString());
            checkBoxCell.setBody((HtmlComponent)checkBox);
            if (!curriculumModuleBean.getGroupsEnroled().isEmpty() || !curriculumModuleBean.getCurricularCoursesEnroled().isEmpty()) {
                checkBox.setDisabled(true);
            } else {
                this.enrollmentsController.addCheckBox(checkBox);
            }
            HtmlTable coursesTable = new HtmlTable();
            blockContainer.addChild((HtmlComponent)coursesTable);
            coursesTable.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getTablesClasses());
            coursesTable.setStyle("width: " + (StudentCurricularPlanEnrolmentsRenderer.this.getInitialWidth() - depth - StudentCurricularPlanEnrolmentsRenderer.this.getWidthDecreasePerLevel()) + "em; margin-left: " + (depth + StudentCurricularPlanEnrolmentsRenderer.this.getWidthDecreasePerLevel()) + "em;");
            this.generateEnrolments(curriculumModuleBean, executionSemester, coursesTable);
            this.generateCurricularCoursesToEnrol(coursesTable, curriculumModuleBean, executionSemester);
            this.generateGroups(blockContainer, curriculumModuleBean, studentCurricularPlan, executionSemester, depth);
        }

        private void generateGroups(HtmlBlockContainer blockContainer, CurriculumModuleBean curriculumModuleBean, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, int depth) {
            ArrayList<DegreeModuleToEnrol> courseGroupsToEnrol = new ArrayList<DegreeModuleToEnrol>(curriculumModuleBean.getGroupsToEnrol());
            Collections.sort(courseGroupsToEnrol, new BeanComparator("context"));
            ArrayList<CurriculumModuleBean> curriculumGroups = new ArrayList<CurriculumModuleBean>(curriculumModuleBean.getGroupsEnroled());
            Collections.sort(curriculumGroups, new CurriculumModuleComparator(executionSemester));
            while (!courseGroupsToEnrol.isEmpty() || !curriculumGroups.isEmpty()) {
                if (!curriculumGroups.isEmpty() && courseGroupsToEnrol.isEmpty()) {
                    this.generateModules(blockContainer, studentCurricularPlan, (CurriculumModuleBean)curriculumGroups.iterator().next(), executionSemester, depth + StudentCurricularPlanEnrolmentsRenderer.this.getWidthDecreasePerLevel());
                    curriculumGroups.remove(0);
                    continue;
                }
                if (curriculumGroups.isEmpty() && !courseGroupsToEnrol.isEmpty()) {
                    this.generateCourseGroupToEnroll(blockContainer, (DegreeModuleToEnrol)courseGroupsToEnrol.iterator().next(), depth + StudentCurricularPlanEnrolmentsRenderer.this.getWidthDecreasePerLevel());
                    courseGroupsToEnrol.remove(0);
                    continue;
                }
                Context context = ((DegreeModuleToEnrol)courseGroupsToEnrol.iterator().next()).getContext();
                CurriculumGroup curriculumGroup = (CurriculumGroup)((Object)((CurriculumModuleBean)curriculumGroups.iterator().next()).getCurriculumModule());
                if (curriculumGroup.getChildOrder(executionSemester) <= context.getChildOrder()) {
                    this.generateModules(blockContainer, studentCurricularPlan, (CurriculumModuleBean)curriculumGroups.iterator().next(), executionSemester, depth + StudentCurricularPlanEnrolmentsRenderer.this.getWidthDecreasePerLevel());
                    curriculumGroups.remove(0);
                    continue;
                }
                this.generateCourseGroupToEnroll(blockContainer, (DegreeModuleToEnrol)courseGroupsToEnrol.iterator().next(), depth + StudentCurricularPlanEnrolmentsRenderer.this.getWidthDecreasePerLevel());
                courseGroupsToEnrol.remove(0);
            }
        }

        private void generateCourseGroupToEnroll(HtmlBlockContainer blockContainer, DegreeModuleToEnrol degreeModuleToEnrol, int depth) {
            HtmlTable groupTable = new HtmlTable();
            blockContainer.addChild((HtmlComponent)groupTable);
            groupTable.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getTablesClasses());
            groupTable.setStyle("width: " + (StudentCurricularPlanEnrolmentsRenderer.this.getInitialWidth() - depth) + "em; margin-left: " + depth + "em;");
            HtmlTableRow htmlTableRow = groupTable.createRow();
            htmlTableRow.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getGroupRowClasses());
            htmlTableRow.createCell().setBody((HtmlComponent)new HtmlText(degreeModuleToEnrol.getContext().getChildDegreeModule().getName()));
            HtmlTableCell checkBoxCell = htmlTableRow.createCell();
            checkBoxCell.setClasses("aright");
            HtmlCheckBox checkBox = new HtmlCheckBox(false);
            checkBox.setName("degreeModuleToEnrolCheckBox" + degreeModuleToEnrol.getContext().getExternalId() + ":" + degreeModuleToEnrol.getCurriculumGroup().getExternalId());
            checkBox.setUserValue(degreeModuleToEnrol.getKey());
            this.degreeModulesToEnrolController.addCheckBox(checkBox);
            checkBoxCell.setBody((HtmlComponent)checkBox);
        }

        private void generateCurricularCoursesToEnrol(HtmlTable groupTable, CurriculumModuleBean curriculumModuleBean, ExecutionSemester executionSemester) {
            List<DegreeModuleToEnrol> coursesToEnrol = curriculumModuleBean.getCurricularCoursesToEnrol();
            Collections.sort(coursesToEnrol, new BeanComparator("context"));
            for (DegreeModuleToEnrol degreeModuleToEnrol : coursesToEnrol) {
                CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModuleToEnrol.getContext().getChildDegreeModule());
                HtmlTableRow htmlTableRow = groupTable.createRow();
                HtmlTableCell cellName = htmlTableRow.createCell();
                cellName.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getCurricularCourseNameClasses());
                cellName.setBody((HtmlComponent)new HtmlText(curricularCourse.getName()));
                HtmlTableCell yearCell = htmlTableRow.createCell();
                yearCell.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getCurricularCourseYearClasses());
                yearCell.setColspan(Integer.valueOf(2));
                StringBuilder year = new StringBuilder();
                year.append(degreeModuleToEnrol.getContext().getCurricularPeriod().getFullLabel());
                yearCell.setBody((HtmlComponent)new HtmlText(year.toString()));
                if (!curricularCourse.isOptionalCurricularCourse()) {
                    HtmlTableCell ectsCell = htmlTableRow.createCell();
                    ectsCell.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getCurricularCourseEctsClasses());
                    StringBuilder ects = new StringBuilder();
                    ects.append(curricularCourse.getEctsCredits()).append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"credits.abbreviation", (String[])new String[0]));
                    ectsCell.setBody((HtmlComponent)new HtmlText(ects.toString()));
                    HtmlTableCell checkBoxCell = htmlTableRow.createCell();
                    checkBoxCell.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getCurricularCourseCheckBoxClasses());
                    HtmlCheckBox checkBox = new HtmlCheckBox(false);
                    checkBox.setName("degreeModuleToEnrolCheckBox" + degreeModuleToEnrol.getContext().getExternalId() + ":" + degreeModuleToEnrol.getCurriculumGroup().getExternalId());
                    checkBox.setUserValue(degreeModuleToEnrol.getKey());
                    this.degreeModulesToEnrolController.addCheckBox(checkBox);
                    checkBoxCell.setBody((HtmlComponent)checkBox);
                    continue;
                }
                HtmlTableCell cell = htmlTableRow.createCell();
                cell.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getCurricularCourseEctsClasses());
                cell.setBody((HtmlComponent)new HtmlText(""));
                HtmlTableCell linkTableCell = htmlTableRow.createCell();
                linkTableCell.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getCurricularCourseCheckBoxClasses());
                HtmlLink htmlLink = new HtmlLink();
                htmlLink.setText(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"link.option.choose.curricular.course", (String[])new String[0]));
                htmlLink.setUrl(StudentCurricularPlanEnrolmentsRenderer.this.getLinkURL());
                htmlLink.setParameter("scpID", this.studentEnrolmentBean.getStudentCurricularPlan().getExternalId());
                htmlLink.setParameter("executionPeriodID", this.studentEnrolmentBean.getExecutionPeriod().getExternalId());
                htmlLink.setParameter("curriculumGroupID", degreeModuleToEnrol.getCurriculumGroup().getExternalId());
                htmlLink.setParameter("contextID", degreeModuleToEnrol.getContext().getExternalId());
                linkTableCell.setBody((HtmlComponent)htmlLink);
            }
        }

        private void generateEnrolments(CurriculumModuleBean curriculumModuleBean, ExecutionSemester executionSemester, HtmlTable groupTable) {
            for (CurriculumModuleBean curriculumModule : curriculumModuleBean.getCurricularCoursesEnroled()) {
                Enrolment enrolment;
                if (!((CurriculumLine)((Object)curriculumModule.getCurriculumModule())).isEnrolment() || !(enrolment = (Enrolment)((Object)curriculumModule.getCurriculumModule())).getExecutionPeriod().equals(executionSemester) || !enrolment.isEnroled()) continue;
                this.generateEnrolment(groupTable, enrolment);
            }
        }

        private void generateEnrolment(HtmlTable groupTable, Enrolment enrolment) {
            HtmlTableRow htmlTableRow = groupTable.createRow();
            HtmlTableCell cellName = htmlTableRow.createCell();
            cellName.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getEnrolmentNameClasses());
            cellName.setBody((HtmlComponent)new HtmlText(enrolment.getName().getContent()));
            HtmlTableCell yearCell = htmlTableRow.createCell();
            yearCell.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getEnrolmentYearClasses());
            StringBuilder year = new StringBuilder();
            year.append(enrolment.getExecutionPeriod().getExecutionYear().getYear());
            yearCell.setBody((HtmlComponent)new HtmlText(year.toString()));
            HtmlTableCell semesterCell = htmlTableRow.createCell();
            semesterCell.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getEnrolmentSemesterClasses());
            StringBuilder semester = new StringBuilder();
            semester.append(enrolment.getExecutionPeriod().getSemester().toString());
            semester.append(" ");
            semester.append(BundleUtil.getString((String)"resources.EnumerationResources", (String)"SEMESTER.ABBREVIATION", (String[])new String[0]));
            semesterCell.setBody((HtmlComponent)new HtmlText(semester.toString()));
            HtmlTableCell ectsCell = htmlTableRow.createCell();
            ectsCell.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getEnrolmentEctsClasses());
            StringBuilder ects = new StringBuilder();
            ects.append(enrolment.getCurricularCourse().getEctsCredits()).append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"credits.abbreviation", (String[])new String[0]));
            ectsCell.setBody((HtmlComponent)new HtmlText(ects.toString()));
            MetaObject enrolmentMetaObject = MetaObjectFactory.createObject((Object)enrolment, (Schema)new Schema(Enrolment.class));
            HtmlCheckBox checkBox = new HtmlCheckBox(true);
            checkBox.setName("enrolmentCheckBox" + enrolment.getExternalId());
            checkBox.setUserValue(enrolmentMetaObject.getKey().toString());
            this.enrollmentsController.addCheckBox(checkBox);
            HtmlTableCell cellCheckBox = htmlTableRow.createCell();
            cellCheckBox.setClasses(StudentCurricularPlanEnrolmentsRenderer.this.getEnrolmentCheckBoxClasses());
            cellCheckBox.setBody((HtmlComponent)checkBox);
        }
    }
}

