/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.bolonhaManager.curricularRules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.component.UISelectItems;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourse;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.DegreeModulesSelectionLimit;
import org.fenixedu.academic.domain.curricularRules.Exclusiveness;
import org.fenixedu.academic.domain.curricularRules.MinimumNumberOfCreditsToEnrol;
import org.fenixedu.academic.domain.curricularRules.PrecedenceRule;
import org.fenixedu.academic.domain.curricularRules.RestrictionBetweenDegreeModules;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.CurricularPeriodInfoDTO;
import org.fenixedu.academic.dto.bolonhaManager.CurricularRuleParametersDTO;
import org.fenixedu.academic.service.services.bolonhaManager.CreateRule;
import org.fenixedu.academic.service.services.bolonhaManager.DeleteCurricularRule;
import org.fenixedu.academic.service.services.bolonhaManager.EditCurricularRule;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.util.CurricularRuleLabelFormatter;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixframework.FenixFramework;

public class CurricularRulesManagementBackingBean
extends FenixBackingBean {
    protected final String NO_SELECTION_STRING = "-1";
    private String degreeModuleID = null;
    private DegreeModule degreeModule = null;
    private DegreeCurricularPlan degreeCurricularPlan = null;
    private CurricularRule curricularRule = null;
    private UISelectItems curricularRuleTypeItems;
    private UISelectItems degreeModuleItems;
    private UISelectItems courseGroupItems;
    private UISelectItems degreeItems;
    private UISelectItems departmentUnitItems;
    private UISelectItems beginExecutionPeriodItemsForRule;
    private UISelectItems endExecutionPeriodItemsForRule;
    private List<SelectItem> executionPeriodItems;

    public String getDegreeCurricularPlanID() {
        return this.getAndHoldStringParameter("degreeCurricularPlanID");
    }

    public String getExecutionYearID() {
        return this.getAndHoldStringParameter("executionYearID");
    }

    public String getOrganizeBy() {
        return this.getAndHoldStringParameter("organizeBy");
    }

    public String getShowRules() {
        return this.getAndHoldStringParameter("showRules");
    }

    public String getHideCourses() {
        return this.getAndHoldStringParameter("hideCourses");
    }

    public String getAction() {
        return this.getAndHoldStringParameter("action");
    }

    public String getSchoolAcronym() {
        return Unit.getInstitutionAcronym();
    }

    public String getType() {
        return this.getAndHoldStringParameter("type");
    }

    public String getDegreeModuleID() {
        if (this.degreeModuleID == null) {
            this.degreeModuleID = this.getAndHoldStringParameter("degreeModuleID");
            if (this.degreeModuleID == null && this.getCurricularRule() != null) {
                this.degreeModuleID = this.getCurricularRule().getDegreeModuleToApplyRule().getExternalId();
            }
        }
        return this.degreeModuleID;
    }

    public DegreeModule getDegreeModule() {
        return this.degreeModule == null ? (this.degreeModule = (DegreeModule)FenixFramework.getDomainObject((String)this.getDegreeModuleID())) : this.degreeModule;
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.degreeCurricularPlan == null ? (this.degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)this.getDegreeCurricularPlanID())) : this.degreeCurricularPlan;
    }

    public String getSelectedCurricularRuleType() {
        if (this.getViewState().getAttribute("selectedCurricularRuleType") == null && this.getCurricularRule() != null && this.getCurricularRule().getCurricularRuleType() != null) {
            this.setSelectedCurricularRuleType(this.getCurricularRule().getCurricularRuleType().getName());
        }
        return (String)this.getViewState().getAttribute("selectedCurricularRuleType");
    }

    public void setSelectedCurricularRuleType(String selectedCurricularRuleType) {
        this.getViewState().setAttribute("selectedCurricularRuleType", selectedCurricularRuleType);
    }

    private List<SelectItem> getRuleTypes() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        block10: for (CurricularRuleType curricularRuleType : CurricularRuleType.values()) {
            switch (curricularRuleType) {
                case CREDITS_LIMIT: {
                    CurricularCourse curricularCourse;
                    if (this.getDegreeModule().isLeaf() && (curricularCourse = (CurricularCourse)((Object)this.getDegreeModule())).isOptionalCurricularCourse()) {
                        result.add(new SelectItem((Object)curricularRuleType.getName(), BundleUtil.getString((String)"resources.EnumerationResources", (String)curricularRuleType.getName(), (String[])new String[0])));
                        continue block10;
                    }
                }
                case DEGREE_MODULES_SELECTION_LIMIT: {
                    if (this.getDegreeModule().isLeaf()) continue block10;
                    result.add(new SelectItem((Object)curricularRuleType.getName(), BundleUtil.getString((String)"resources.EnumerationResources", (String)curricularRuleType.getName(), (String[])new String[0])));
                    continue block10;
                }
                case PRECEDENCY_BETWEEN_DEGREE_MODULES: {
                    result.add(new SelectItem((Object)curricularRuleType.getName(), BundleUtil.getString((String)"resources.EnumerationResources", (String)curricularRuleType.getName(), (String[])new String[0])));
                    continue block10;
                }
                case PRECEDENCY_APPROVED_DEGREE_MODULE: 
                case PRECEDENCY_ENROLED_DEGREE_MODULE: 
                case RESTRICTION_NOT_ENROLED_DEGREE_MODULE: 
                case ENROLMENT_TO_BE_APPROVED_BY_COORDINATOR: {
                    if (!this.getDegreeModule().isLeaf()) continue block10;
                    result.add(new SelectItem((Object)curricularRuleType.getName(), BundleUtil.getString((String)"resources.EnumerationResources", (String)curricularRuleType.getName(), (String[])new String[0])));
                    continue block10;
                }
                case EXCLUSIVENESS: {
                    result.add(new SelectItem((Object)curricularRuleType.getName(), BundleUtil.getString((String)"resources.EnumerationResources", (String)curricularRuleType.getName(), (String[])new String[0])));
                    continue block10;
                }
                case ANY_CURRICULAR_COURSE: {
                    CurricularCourse curricularCourse;
                    if (!this.getDegreeModule().isLeaf() || !(curricularCourse = (CurricularCourse)((Object)this.getDegreeModule())).isOptionalCurricularCourse()) continue block10;
                    result.add(new SelectItem((Object)curricularRuleType.getName(), BundleUtil.getString((String)"resources.EnumerationResources", (String)curricularRuleType.getName(), (String[])new String[0])));
                    continue block10;
                }
                case EVEN_ODD: {
                    if (!this.getDegreeModule().isLeaf()) continue block10;
                    result.add(new SelectItem((Object)curricularRuleType.getName(), BundleUtil.getString((String)"resources.EnumerationResources", (String)curricularRuleType.getName(), (String[])new String[0])));
                    continue block10;
                }
                case MINIMUM_NUMBER_OF_CREDITS_TO_ENROL: {
                    result.add(new SelectItem((Object)curricularRuleType.getName(), BundleUtil.getString((String)"resources.EnumerationResources", (String)curricularRuleType.getName(), (String[])new String[0])));
                    continue block10;
                }
            }
        }
        Collections.sort(result, new BeanComparator("label"));
        result.add(0, new SelectItem((Object)"-1", BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        return result;
    }

    public List<String> getRulesLabels() {
        ArrayList<String> resultLabels = new ArrayList<String>();
        for (CurricularRule curricularRule : this.getDegreeModule().getCurricularRulesSet()) {
            resultLabels.add(CurricularRuleLabelFormatter.getLabel(curricularRule));
        }
        return resultLabels;
    }

    public String getRuleLabel() {
        return CurricularRuleLabelFormatter.getLabel(this.getCurricularRule());
    }

    public UISelectItems getCurricularRuleTypeItems() {
        if (this.curricularRuleTypeItems == null) {
            this.curricularRuleTypeItems = new UISelectItems();
            this.curricularRuleTypeItems.setValue(this.getRuleTypes());
        }
        return this.curricularRuleTypeItems;
    }

    public void setCurricularRuleTypeItems(UISelectItems ruleTypeItems) {
        this.curricularRuleTypeItems = ruleTypeItems;
    }

    public void onChangeCurricularRuleTypeDropDown(ValueChangeEvent event) {
        this.getDegreeModuleItems().setValue(this.readDegreeModules((String)event.getNewValue()));
        this.getCourseGroupItems().setValue(this.readParentCourseGroups((String)event.getNewValue()));
        this.getDegreeItems().setValue(this.readBolonhaDegrees((String)event.getNewValue(), this.getSelectedDegreeType()));
        this.getDepartmentUnitItems().setValue(this.readDepartmentUnits((String)event.getNewValue()));
    }

    public void onChangeDegreeTypeDropDown(ValueChangeEvent event) {
        this.getDegreeItems().setValue(this.readBolonhaDegrees(this.getSelectedCurricularRuleType(), (String)event.getNewValue()));
    }

    public String getSelectedDegreeModuleID() {
        if (this.getViewState().getAttribute("selectedDegreeModuleID") == null && this.getCurricularRule() != null) {
            if (this.getCurricularRule() instanceof PrecedenceRule) {
                this.setSelectedDegreeModuleID(((PrecedenceRule)((Object)this.getCurricularRule())).getPrecedenceDegreeModule().getExternalId());
            } else if (this.getCurricularRule() instanceof Exclusiveness) {
                this.setSelectedDegreeModuleID(((Exclusiveness)((Object)this.getCurricularRule())).getExclusiveDegreeModule().getExternalId());
            }
        }
        return (String)this.getViewState().getAttribute("selectedDegreeModuleID");
    }

    public void setSelectedDegreeModuleID(String selectedDegreeModuleID) {
        this.getViewState().setAttribute("selectedDegreeModuleID", selectedDegreeModuleID);
    }

    public String getSelectedContextCourseGroupID() {
        if (this.getViewState().getAttribute("selectedContextCourseGroupID") == null && this.getCurricularRule() != null && this.getCurricularRule().getContextCourseGroup() != null) {
            this.setSelectedContextCourseGroupID(this.getCurricularRule().getContextCourseGroup().getExternalId());
        }
        return (String)this.getViewState().getAttribute("selectedContextCourseGroupID");
    }

    public void setSelectedContextCourseGroupID(String selectedContextCourseGroupID) {
        this.getViewState().setAttribute("selectedContextCourseGroupID", selectedContextCourseGroupID);
    }

    public Integer getMinimumLimit() {
        if (this.getViewState().getAttribute("minimumLimit") == null) {
            if (this.getCurricularRule() != null && this.getCurricularRule() instanceof DegreeModulesSelectionLimit) {
                this.setMinimumLimit(((DegreeModulesSelectionLimit)((Object)this.getCurricularRule())).getMinimumLimit());
            } else {
                this.setMinimumLimit(0);
            }
        }
        return (Integer)this.getViewState().getAttribute("minimumLimit");
    }

    public void setMinimumLimit(Integer minimumLimit) {
        this.getViewState().setAttribute("minimumLimit", minimumLimit);
    }

    public Integer getMaximumLimit() {
        if (this.getViewState().getAttribute("maximumLimit") == null) {
            if (this.getCurricularRule() != null && this.getCurricularRule() instanceof DegreeModulesSelectionLimit) {
                this.setMaximumLimit(((DegreeModulesSelectionLimit)((Object)this.getCurricularRule())).getMaximumLimit());
            } else {
                this.setMaximumLimit(0);
            }
        }
        return (Integer)this.getViewState().getAttribute("maximumLimit");
    }

    public void setMaximumLimit(Integer maximumLimit) {
        this.getViewState().setAttribute("maximumLimit", maximumLimit);
    }

    public Double getMinimumCredits() {
        if (this.getViewState().getAttribute("minimumCredits") == null) {
            if (this.getCurricularRule() != null && this.getCurricularRule() instanceof CreditsLimit) {
                this.setMinimumCredits(((CreditsLimit)((Object)this.getCurricularRule())).getMinimumCredits());
            } else if (this.getCurricularRule() != null && this.getCurricularRule() instanceof RestrictionBetweenDegreeModules) {
                this.setMinimumCredits(((RestrictionBetweenDegreeModules)((Object)this.getCurricularRule())).getMinimumCredits());
            } else if (this.getCurricularRule() != null && this.getCurricularRule() instanceof MinimumNumberOfCreditsToEnrol) {
                this.setMinimumCredits(((MinimumNumberOfCreditsToEnrol)((Object)this.getCurricularRule())).getMinimumCredits());
            } else {
                this.setMinimumCredits(0.0);
            }
        }
        return (Double)this.getViewState().getAttribute("minimumCredits");
    }

    public void setMinimumCredits(Double minimumCredits) {
        this.getViewState().setAttribute("minimumCredits", minimumCredits);
    }

    public Double getMaximumCredits() {
        if (this.getViewState().getAttribute("maximumCredits") == null) {
            if (this.getCurricularRule() != null && this.getCurricularRule() instanceof CreditsLimit) {
                this.setMaximumCredits(((CreditsLimit)((Object)this.getCurricularRule())).getMaximumCredits());
            } else {
                this.setMaximumCredits(0.0);
            }
        }
        return (Double)this.getViewState().getAttribute("maximumCredits");
    }

    public void setMaximumCredits(Double maximumCredits) {
        this.getViewState().setAttribute("maximumCredits", maximumCredits);
    }

    public String getSelectedSemester() {
        if (this.getViewState().getAttribute("selectedSemester") == null) {
            if (this.getCurricularRule() != null && this.getCurricularRule() instanceof PrecedenceRule) {
                PrecedenceRule precedenceRule = (PrecedenceRule)((Object)this.getCurricularRule());
                this.setSelectedSemester(precedenceRule.getCurricularPeriodOrder() != null ? precedenceRule.getCurricularPeriodOrder().toString() : "0");
            } else if (this.getCurricularRule() != null && this.getCurricularRule() instanceof AnyCurricularCourse) {
                this.setSelectedSemester(((AnyCurricularCourse)((Object)this.getCurricularRule())).getCurricularPeriodOrder().toString());
            } else {
                this.setSelectedSemester("0");
            }
        }
        return (String)this.getViewState().getAttribute("selectedSemester");
    }

    public void setSelectedSemester(String selectedSemester) {
        this.getViewState().setAttribute("selectedSemester", selectedSemester);
    }

    public void setSelectedEven(String selectedSemester) {
        this.getViewState().setAttribute("even", selectedSemester);
    }

    public String getSelectedEven() {
        return (String)this.getViewState().getAttribute("even");
    }

    public String getCurricularRuleID() {
        return this.getAndHoldStringParameter("curricularRuleID");
    }

    public CurricularRule getCurricularRule() {
        return this.curricularRule == null ? (this.curricularRule = (CurricularRule)FenixFramework.getDomainObject((String)this.getCurricularRuleID())) : this.curricularRule;
    }

    public UISelectItems getDegreeModuleItems() {
        if (this.degreeModuleItems == null) {
            this.degreeModuleItems = new UISelectItems();
            this.degreeModuleItems.setValue(this.readDegreeModules(this.getSelectedCurricularRuleType()));
        }
        return this.degreeModuleItems;
    }

    public void setDegreeModuleItems(UISelectItems degreeModuleItems) {
        this.degreeModuleItems = degreeModuleItems;
    }

    public UISelectItems getCourseGroupItems() {
        if (this.courseGroupItems == null) {
            this.courseGroupItems = new UISelectItems();
            this.courseGroupItems.setValue(this.readParentCourseGroups(this.getSelectedCurricularRuleType()));
        }
        return this.courseGroupItems;
    }

    public void setCourseGroupItems(UISelectItems courseGroupItems) {
        this.courseGroupItems = courseGroupItems;
    }

    public Integer getMinimumYear() {
        AnyCurricularCourse anyCurricularCourse;
        if (this.getViewState().getAttribute("minimumYear") == null && this.getCurricularRule() != null && this.getCurricularRule() instanceof AnyCurricularCourse && (anyCurricularCourse = (AnyCurricularCourse)((Object)this.getCurricularRule())).getMinimumYear() != null) {
            this.setMinimumYear(anyCurricularCourse.getMinimumYear());
        }
        return (Integer)this.getViewState().getAttribute("minimumYear");
    }

    public void setMinimumYear(Integer minimumYear) {
        if (minimumYear == null) {
            this.getViewState().removeAttribute("minimumYear");
        } else {
            this.getViewState().setAttribute("minimumYear", minimumYear);
        }
    }

    public Integer getMaximumYear() {
        AnyCurricularCourse anyCurricularCourse;
        if (this.getViewState().getAttribute("maximumYear") == null && this.getCurricularRule() != null && this.getCurricularRule() instanceof AnyCurricularCourse && (anyCurricularCourse = (AnyCurricularCourse)((Object)this.getCurricularRule())).getMaximumYear() != null) {
            this.setMaximumYear(anyCurricularCourse.getMaximumYear());
        }
        return (Integer)this.getViewState().getAttribute("maximumYear");
    }

    public void setMaximumYear(Integer maximumYear) {
        if (maximumYear == null) {
            this.getViewState().removeAttribute("maximumYear");
        } else {
            this.getViewState().setAttribute("maximumYear", maximumYear);
        }
    }

    public Double getCredits() {
        AnyCurricularCourse anyCurricularCourse;
        if (this.getViewState().getAttribute("credits") == null && this.getCurricularRule() != null && this.getCurricularRule() instanceof AnyCurricularCourse && (anyCurricularCourse = (AnyCurricularCourse)((Object)this.getCurricularRule())).getCredits() != null) {
            this.setCredits(anyCurricularCourse.getCredits());
        }
        return (Double)this.getViewState().getAttribute("credits");
    }

    public void setCredits(Double credits) {
        if (credits == null) {
            this.getViewState().removeAttribute("credits");
        } else {
            this.getViewState().setAttribute("credits", credits);
        }
    }

    public String getSelectedDegreeType() {
        AnyCurricularCourse anyCurricularCourse;
        if (this.getViewState().getAttribute("selectedDegreeType") == null && this.getCurricularRule() != null && this.getCurricularRule() instanceof AnyCurricularCourse && (anyCurricularCourse = (AnyCurricularCourse)((Object)this.getCurricularRule())).getBolonhaDegreeType() != null) {
            this.setSelectedDegreeType(anyCurricularCourse.getBolonhaDegreeType().getExternalId());
        }
        return (String)this.getViewState().getAttribute("selectedDegreeType");
    }

    public void setSelectedDegreeType(String selectedDegreeType) {
        this.getViewState().setAttribute("selectedDegreeType", selectedDegreeType);
    }

    public String getSelectedDegreeID() {
        if (this.getViewState().getAttribute("selectedDegreeID") == null) {
            if (this.getCurricularRule() != null && this.getCurricularRule() instanceof AnyCurricularCourse) {
                AnyCurricularCourse anyCurricularCourse = (AnyCurricularCourse)((Object)this.getCurricularRule());
                this.setSelectedDegreeID(anyCurricularCourse.getDegree() != null ? anyCurricularCourse.getDegree().getExternalId() : this.NO_SELECTION_STRING);
            } else {
                this.setSelectedDegreeID("-1");
            }
        }
        return (String)this.getViewState().getAttribute("selectedDegreeID");
    }

    public void setSelectedDegreeID(String selectedDegreeID) {
        this.getViewState().setAttribute("selectedDegreeID", selectedDegreeID);
    }

    public String getSelectedDepartmentUnitID() {
        if (this.getViewState().getAttribute("selectedDepartmentUnitID") == null) {
            if (this.getCurricularRule() != null && this.getCurricularRule() instanceof AnyCurricularCourse) {
                AnyCurricularCourse anyCurricularCourse = (AnyCurricularCourse)((Object)this.getCurricularRule());
                this.setSelectedDepartmentUnitID(anyCurricularCourse.getDepartmentUnit() != null ? anyCurricularCourse.getDepartmentUnit().getExternalId() : this.NO_SELECTION_STRING);
            } else {
                this.setSelectedDepartmentUnitID("-1");
            }
        }
        return (String)this.getViewState().getAttribute("selectedDepartmentUnitID");
    }

    public void setSelectedDepartmentUnitID(String selectedDepartmentUnitID) {
        this.getViewState().setAttribute("selectedDepartmentUnitID", selectedDepartmentUnitID);
    }

    public UISelectItems getDegreeItems() {
        if (this.degreeItems == null) {
            this.degreeItems = new UISelectItems();
            this.degreeItems.setValue(this.readBolonhaDegrees(this.getSelectedCurricularRuleType(), this.getSelectedDegreeType()));
        }
        return this.degreeItems;
    }

    public void setDegreeItems(UISelectItems degreeItems) {
        this.degreeItems = degreeItems;
    }

    private List<SelectItem> readBolonhaDegrees(String selectedCurricularRuleType, String selectedDegreeType) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        if (selectedCurricularRuleType != null && selectedCurricularRuleType.equals(CurricularRuleType.ANY_CURRICULAR_COURSE.name())) {
            List<Degree> allDegrees = Degree.readNotEmptyDegrees();
            DegreeType bolonhaDegreeType = selectedDegreeType == null || selectedDegreeType.equals("-1") ? null : (DegreeType)FenixFramework.getDomainObject((String)selectedDegreeType);
            for (Degree degree : allDegrees) {
                if (!degree.isBolonhaDegree() || bolonhaDegreeType != null && degree.getDegreeType() != bolonhaDegreeType) continue;
                result.add(new SelectItem((Object)degree.getExternalId(), "[" + degree.getDegreeType().getName().getContent() + "] " + degree.getNome()));
            }
            Collections.sort(result, new BeanComparator("label"));
        }
        result.add(0, new SelectItem((Object)"-1", BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"any.one", (String[])new String[0])));
        return result;
    }

    public UISelectItems getDepartmentUnitItems() {
        if (this.departmentUnitItems == null) {
            this.departmentUnitItems = new UISelectItems();
            this.departmentUnitItems.setValue(this.readDepartmentUnits(this.getSelectedCurricularRuleType()));
        }
        return this.departmentUnitItems;
    }

    public void setDepartmentUnitItems(UISelectItems departmentUnitItems) {
        this.departmentUnitItems = departmentUnitItems;
    }

    public String getBeginExecutionPeriodID() {
        if (this.getViewState().getAttribute("beginExecutionPeriodID") == null && this.getCurricularRule() != null) {
            this.setBeginExecutionPeriodID(this.getCurricularRule().getBegin().getExternalId());
        }
        return (String)this.getViewState().getAttribute("beginExecutionPeriodID");
    }

    public void setBeginExecutionPeriodID(String beginExecutionPeriodID) {
        this.getViewState().setAttribute("beginExecutionPeriodID", beginExecutionPeriodID);
    }

    public String getEndExecutionPeriodID() {
        if (this.getViewState().getAttribute("endExecutionPeriodID") == null && this.getCurricularRule() != null) {
            this.setEndExecutionPeriodID(this.getCurricularRule().getEnd() == null ? this.NO_SELECTION_STRING : this.getCurricularRule().getEnd().getExternalId());
        }
        return (String)this.getViewState().getAttribute("endExecutionPeriodID");
    }

    public void setEndExecutionPeriodID(String endExecutionPeriodID) {
        this.getViewState().setAttribute("endExecutionPeriodID", endExecutionPeriodID);
    }

    public UISelectItems getBeginExecutionPeriodItemsForRule() {
        if (this.beginExecutionPeriodItemsForRule == null) {
            this.beginExecutionPeriodItemsForRule = new UISelectItems();
            this.beginExecutionPeriodItemsForRule.setValue(this.readExecutionPeriodItems());
        }
        return this.beginExecutionPeriodItemsForRule;
    }

    public void setBeginExecutionPeriodItemsForRule(UISelectItems beginExecutionPeriodItemsForRule) {
        this.beginExecutionPeriodItemsForRule = beginExecutionPeriodItemsForRule;
    }

    public UISelectItems getEndExecutionPeriodItemsForRule() {
        if (this.endExecutionPeriodItemsForRule == null) {
            this.endExecutionPeriodItemsForRule = new UISelectItems();
            ArrayList<SelectItem> values = new ArrayList<SelectItem>(this.readExecutionPeriodItems());
            values.add(0, new SelectItem((Object)"-1", BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"opened", (String[])new String[0])));
            this.endExecutionPeriodItemsForRule.setValue(values);
        }
        return this.endExecutionPeriodItemsForRule;
    }

    public void setEndExecutionPeriodItemsForRule(UISelectItems endExecutionPeriodItemsForRule) {
        this.endExecutionPeriodItemsForRule = endExecutionPeriodItemsForRule;
    }

    protected List<SelectItem> readExecutionPeriodItems() {
        if (this.executionPeriodItems != null) {
            return this.executionPeriodItems;
        }
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        DegreeModule degreeModule = this.getDegreeModule();
        ExecutionSemester currentExecutionPeriod = degreeModule != null ? degreeModule.getMinimumExecutionPeriod() : ExecutionSemester.readActualExecutionSemester();
        List<ExecutionSemester> notClosedExecutionPeriods = ExecutionSemester.readNotClosedExecutionPeriods();
        Collections.sort(notClosedExecutionPeriods);
        for (ExecutionSemester notClosedExecutionPeriod : notClosedExecutionPeriods) {
            if (!notClosedExecutionPeriod.isAfterOrEquals(currentExecutionPeriod)) continue;
            result.add(new SelectItem((Object)notClosedExecutionPeriod.getExternalId(), notClosedExecutionPeriod.getName() + " " + notClosedExecutionPeriod.getExecutionYear().getYear()));
        }
        this.executionPeriodItems = result;
        return this.executionPeriodItems;
    }

    private Object readDepartmentUnits(String selectedCurricularRuleType) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        if (selectedCurricularRuleType != null && selectedCurricularRuleType.equals(CurricularRuleType.ANY_CURRICULAR_COURSE.name())) {
            for (Unit unit : UnitUtils.readAllDepartmentUnits()) {
                result.add(new SelectItem((Object)unit.getExternalId(), unit.getName()));
            }
            Collections.sort(result, new BeanComparator("label"));
        }
        result.add(0, new SelectItem((Object)"-1", BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        return result;
    }

    private Object readParentCourseGroups(String selectedCurricularRuleType) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        if (selectedCurricularRuleType != null && !selectedCurricularRuleType.equals("-1")) {
            for (Context context : this.getDegreeModule().getParentContextsSet()) {
                CourseGroup courseGroup = context.getParentCourseGroup();
                if (courseGroup.isRoot()) continue;
                result.add(new SelectItem((Object)courseGroup.getExternalId(), courseGroup.getName()));
            }
            Collections.sort(result, new BeanComparator("label"));
        }
        result.add(0, new SelectItem((Object)"-1", BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"all", (String[])new String[0])));
        return result;
    }

    private List<SelectItem> readDegreeModules(String selectedCurricularRuleType) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        if (selectedCurricularRuleType != null && !selectedCurricularRuleType.equals("-1")) {
            switch (CurricularRuleType.valueOf(selectedCurricularRuleType)) {
                case PRECEDENCY_APPROVED_DEGREE_MODULE: 
                case PRECEDENCY_ENROLED_DEGREE_MODULE: 
                case RESTRICTION_NOT_ENROLED_DEGREE_MODULE: {
                    this.getDegreeModules(CurricularCourse.class, result);
                    break;
                }
                case CREDITS_LIMIT: 
                case DEGREE_MODULES_SELECTION_LIMIT: {
                    this.getDegreeModules(CourseGroup.class, result);
                    break;
                }
                case PRECEDENCY_BETWEEN_DEGREE_MODULES: {
                    this.getDegreeModules(DegreeModule.class, result);
                    break;
                }
                case EXCLUSIVENESS: {
                    this.getDegreeModules(((Object)((Object)this.getDegreeModule())).getClass(), result);
                    break;
                }
            }
        }
        result.add(0, new SelectItem((Object)"-1", BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        return result;
    }

    private void getDegreeModules(Class<? extends DegreeModule> clazz, List<SelectItem> result) {
        List<List<DegreeModule>> degreeModulesSet = this.getDegreeCurricularPlan().getDcpDegreeModulesIncludingFullPath(clazz, null);
        for (List<DegreeModule> degreeModules : degreeModulesSet) {
            DegreeModule lastDegreeModule = degreeModules.size() > 0 ? degreeModules.get(degreeModules.size() - 1) : null;
            if (lastDegreeModule == this.getDegreeModule()) continue;
            StringBuilder pathName = new StringBuilder();
            for (DegreeModule degreeModule : degreeModules) {
                pathName.append(pathName.length() == 0 ? "" : " > ").append(degreeModule.getName());
            }
            result.add(new SelectItem((Object)lastDegreeModule.getExternalId(), pathName.toString()));
        }
        Collections.sort(result, new BeanComparator("label"));
    }

    private String getFinalEndExecutionPeriodID() {
        return this.getViewState().getAttribute("endExecutionPeriodID") == null || this.getViewState().getAttribute("endExecutionPeriodID").equals("-1") ? null : (String)this.getViewState().getAttribute("endExecutionPeriodID");
    }

    public String createCurricularRule() {
        try {
            this.checkSelectedAttributes();
            CreateRule.run(this.getDegreeModuleID(), CurricularRuleType.valueOf(this.getSelectedCurricularRuleType()), this.buildCurricularRuleParametersDTO(), this.getBeginExecutionPeriodID(), this.getFinalEndExecutionPeriodID());
            return "setCurricularRules";
        }
        catch (FenixActionException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.notAuthorized", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (NumberFormatException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"invalid.minimum.maximum.values", (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }

    public String editCurricularRule() {
        try {
            EditCurricularRule.run(this.getCurricularRuleID(), this.getBeginExecutionPeriodID(), this.getFinalEndExecutionPeriodID());
            return "setCurricularRules";
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }

    public String deleteCurricularRule() {
        try {
            DeleteCurricularRule.run(this.getCurricularRuleID());
            this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"curricularRule.deleted", (String[])new String[0]));
            return "setCurricularRules";
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getKey(), (String[])e.getArgs()));
        }
        return "";
    }

    private void checkSelectedAttributes() throws FenixActionException, FenixServiceException {
        if (this.getSelectedCurricularRuleType() == null || this.getSelectedCurricularRuleType().equals("-1")) {
            throw new FenixActionException("must.select.curricular.rule.type");
        }
    }

    private CurricularRuleParametersDTO buildCurricularRuleParametersDTO() throws FenixServiceException, NumberFormatException {
        CurricularRuleParametersDTO parametersDTO = new CurricularRuleParametersDTO();
        parametersDTO.setSelectedDegreeModuleID(this.getSelectedDegreeModuleID());
        parametersDTO.setContextCourseGroupID(this.getSelectedContextCourseGroupID() == null || this.getSelectedContextCourseGroupID().equals("-1") ? null : this.getSelectedContextCourseGroupID());
        parametersDTO.setCurricularPeriodInfoDTO(new CurricularPeriodInfoDTO(Integer.valueOf(this.getSelectedSemester()), AcademicPeriod.SEMESTER));
        parametersDTO.setMinimumCredits(this.getMinimumCredits());
        parametersDTO.setMaximumCredits(this.getMaximumCredits());
        parametersDTO.setMinimumLimit(this.getMinimumLimit());
        parametersDTO.setMaximumLimit(this.getMaximumLimit());
        parametersDTO.setSelectedDegreeID(this.getSelectedDegreeID() == null || this.getSelectedDegreeID().equals("-1") ? null : this.getSelectedDegreeID());
        parametersDTO.setSelectedDepartmentUnitID(this.getSelectedDepartmentUnitID() == null || this.getSelectedDepartmentUnitID().equals("-1") ? null : this.getSelectedDepartmentUnitID());
        parametersDTO.setDegreeType(this.getSelectedDegreeType() == null || this.getSelectedDegreeType().equals("-1") ? null : (DegreeType)FenixFramework.getDomainObject((String)this.getSelectedDegreeType()));
        parametersDTO.setMinimumYear((Integer)this.getViewState().getAttribute("minimumYear"));
        parametersDTO.setMaximumYear((Integer)this.getViewState().getAttribute("maximumYear"));
        parametersDTO.setCredits((Double)this.getViewState().getAttribute("credits"));
        parametersDTO.setEven(Boolean.valueOf(this.getSelectedEven()));
        return parametersDTO;
    }
}

