/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.task;

import java.util.Locale;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.AggregateUnit;
import org.fenixedu.academic.domain.organizationalStructure.CountryUnit;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.SchoolUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.scheduler.custom.CustomTask;
import org.joda.time.YearMonthDay;

public class LoadOrganizationalStructure
extends CustomTask {
    public void runTask() throws Exception {
        CountryUnit countryUnit = this.getCountryUnit(Country.readDefault().getName());
        UniversityUnit universityUnit = this.createUniversityUnit(countryUnit, "Starfleet Univeristy", "SU");
        SchoolUnit institutionUnit = this.createSchoolUnit(universityUnit, "Starflet Academy", "SA");
        Bennu.getInstance().setInstitutionUnit((Unit)((Object)institutionUnit));
        AggregateUnit serviceUnits = this.createAggregateUnit((Unit)((Object)institutionUnit), "Services");
        AggregateUnit departmentUnits = this.createAggregateUnit((Unit)((Object)institutionUnit), "Departments");
        AggregateUnit degreeUnits = this.createAggregateUnit((Unit)((Object)institutionUnit), "Degrees");
    }

    private CountryUnit getCountryUnit(String countryUnitName) {
        for (Party party : Bennu.getInstance().getPartysSet()) {
            CountryUnit countryUnit;
            if (!party.isCountryUnit() || !(countryUnit = (CountryUnit)((Object)party)).getName().equalsIgnoreCase(countryUnitName)) continue;
            return countryUnit;
        }
        return null;
    }

    private UniversityUnit createUniversityUnit(CountryUnit countryUnit, String universityName, String universityAcronym) {
        return UniversityUnit.createNewUniversityUnit(new MultiLanguageString(Locale.getDefault(), universityName), null, null, universityAcronym, new YearMonthDay(), null, (Unit)((Object)countryUnit), null, null, false, null);
    }

    private SchoolUnit createSchoolUnit(UniversityUnit universityUnit, String universityName, String universityAcronym) {
        return SchoolUnit.createNewSchoolUnit(new MultiLanguageString(Locale.getDefault(), universityName), null, null, universityAcronym, new YearMonthDay(), null, (Unit)((Object)universityUnit), null, null, Boolean.FALSE, null);
    }

    private AggregateUnit createAggregateUnit(Unit parentUnit, String unitName) {
        return AggregateUnit.createNewAggregateUnit(new MultiLanguageString(Locale.getDefault(), unitName), null, null, null, new YearMonthDay(), null, parentUnit, AccountabilityType.readByType(AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE), null, null, Boolean.FALSE, null);
    }
}

