/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.thesis;

import java.io.IOException;
import java.util.Locale;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisFile;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.bennu.core.security.Authenticate;

public abstract class CreateThesisFile {
    public ThesisFile run(Thesis thesis, byte[] bytes, String fileName, String title, String subTitle, Locale language) throws FenixServiceException, IOException {
        if (!thesis.isWaitingConfirmation() && !RoleType.SCIENTIFIC_COUNCIL.isMember(Authenticate.getUser().getPerson().getUser())) {
            throw new DomainException("thesis.files.submit.unavailable", new String[0]);
        }
        if (!thesis.isDeclarationAccepted() && !RoleType.SCIENTIFIC_COUNCIL.isMember(Authenticate.getUser().getPerson().getUser())) {
            throw new DomainException("thesis.files.submit.unavailable", new String[0]);
        }
        this.removePreviousFile(thesis);
        if (bytes == null || fileName == null) {
            return null;
        }
        ThesisFile file = new ThesisFile(fileName, fileName, bytes);
        this.updateThesis(thesis, file, title, subTitle, language, fileName, bytes);
        return file;
    }

    protected abstract void removePreviousFile(Thesis var1);

    protected abstract void updateThesis(Thesis var1, ThesisFile var2, String var3, String var4, Locale var5, String var6, byte[] var7) throws FenixServiceException, IOException;
}

