/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.gep;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degree.degreeCurricularPlan.DegreeCurricularPlanState;
import org.fenixedu.academic.domain.studentCurricularPlan.Specialization;
import org.fenixedu.academic.dto.InfoStudentCurricularPlanWithFirstTimeEnrolment;
import org.fenixedu.academic.service.services.gep.ListMasterDegreeStudents$callable$run;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ListMasterDegreeStudents {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static Collection run(String string) {
        return (Collection)advice$run.perform((Callable)new ListMasterDegreeStudents$callable$run(string));
    }

    static /* synthetic */ Collection advised$run(String executionYearName) {
        final ExecutionYear executionYear = ExecutionYear.readExecutionYearByName(executionYearName);
        ArrayList<InfoStudentCurricularPlanWithFirstTimeEnrolment> infoStudentCurricularPlans = new ArrayList<InfoStudentCurricularPlanWithFirstTimeEnrolment>();
        ArrayList studentCurricularPlans = new ArrayList();
        List<DegreeCurricularPlan> masterDegreeCurricularPlans = ListMasterDegreeStudents.readByDegreeTypeAndState();
        CollectionUtils.filter(masterDegreeCurricularPlans, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)((Object)arg0);
                for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                    if (!executionDegree.getExecutionYear().equals(executionYear)) continue;
                    return true;
                }
                return false;
            }
        });
        for (DegreeCurricularPlan degreeCurricularPlan : masterDegreeCurricularPlans) {
            studentCurricularPlans.addAll(degreeCurricularPlan.getStudentCurricularPlansSet());
        }
        for (StudentCurricularPlan studentCurricularPlan : studentCurricularPlans) {
            if (!studentCurricularPlan.isActive()) continue;
            boolean firstTimeEnrolment = true;
            if (studentCurricularPlan.getSpecialization() != null && studentCurricularPlan.getSpecialization().equals((Object)Specialization.STUDENT_CURRICULAR_PLAN_MASTER_DEGREE)) {
                List<StudentCurricularPlan> previousStudentCurricularPlans = studentCurricularPlan.getRegistration().getStudentCurricularPlansBySpecialization(Specialization.STUDENT_CURRICULAR_PLAN_MASTER_DEGREE);
                previousStudentCurricularPlans.remove((Object)studentCurricularPlan);
                for (StudentCurricularPlan previousStudentCurricularPlan : previousStudentCurricularPlans) {
                    if (!previousStudentCurricularPlan.getDegreeCurricularPlan().getDegree().equals(studentCurricularPlan.getDegreeCurricularPlan().getDegree())) continue;
                    firstTimeEnrolment = false;
                    break;
                }
            } else if (studentCurricularPlan.getSpecialization() != null && studentCurricularPlan.getSpecialization().equals((Object)Specialization.STUDENT_CURRICULAR_PLAN_SPECIALIZATION) && !studentCurricularPlan.getDegreeCurricularPlan().getFirstExecutionDegree().getExecutionYear().equals(executionYear)) continue;
            if (firstTimeEnrolment && !studentCurricularPlan.getDegreeCurricularPlan().getFirstExecutionDegree().getExecutionYear().equals(executionYear)) {
                firstTimeEnrolment = false;
            }
            InfoStudentCurricularPlanWithFirstTimeEnrolment infoStudentCurricularPlan = InfoStudentCurricularPlanWithFirstTimeEnrolment.newInfoFromDomain(studentCurricularPlan);
            infoStudentCurricularPlan.setFirstTimeEnrolment(firstTimeEnrolment);
            infoStudentCurricularPlans.add(infoStudentCurricularPlan);
        }
        return infoStudentCurricularPlans;
    }

    private static List<DegreeCurricularPlan> readByDegreeTypeAndState() {
        ArrayList<DegreeCurricularPlan> result = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : DegreeCurricularPlan.readNotEmptyDegreeCurricularPlans()) {
            if (!degreeCurricularPlan.getDegree().getDegreeType().isPreBolonhaMasterDegree() || degreeCurricularPlan.getState() != DegreeCurricularPlanState.ACTIVE) continue;
            result.add(degreeCurricularPlan);
        }
        return result;
    }
}

