/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.enrollment.shift;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.service.ServiceMonitoring;
import org.fenixedu.academic.service.filter.enrollment.ClassEnrollmentAuthorizationFilter;
import org.fenixedu.academic.service.services.enrollment.shift.WriteStudentAttendingCourse$callable$runWriteStudentAttendingCourse;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class WriteStudentAttendingCourse {
    private static final WriteStudentAttendingCourse serviceInstance;
    public static final Advice advice$runWriteStudentAttendingCourse;

    protected void run(Registration registration, String executionCourseId) throws FenixServiceException {
        ServiceMonitoring.logService(this.getClass(), new Object[]{registration, executionCourseId});
        if (registration == null) {
            throw new FenixServiceException("error.registration.not.exist");
        }
        registration.addAttendsTo(this.readExecutionCourse(executionCourseId));
    }

    private ExecutionCourse readExecutionCourse(String executionCourseId) throws FenixServiceException {
        if (Strings.isNullOrEmpty((String)executionCourseId)) {
            throw new FenixServiceException("errors.notSelected.executionCourse");
        }
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseId);
        if (executionCourse == null) {
            throw new FenixServiceException("error.executionCourse.not.exist");
        }
        return executionCourse;
    }

    public static void runWriteStudentAttendingCourse(Registration registration, String string) throws FenixServiceException, NotAuthorizedException {
        Object object = advice$runWriteStudentAttendingCourse.perform((Callable)new WriteStudentAttendingCourse$callable$runWriteStudentAttendingCourse(registration, string));
    }

    static /* synthetic */ void advised$runWriteStudentAttendingCourse(Registration registration, String executionCourseId) throws FenixServiceException, NotAuthorizedException {
        ClassEnrollmentAuthorizationFilter.instance.execute(registration);
        serviceInstance.run(registration, executionCourseId);
    }

    static {
        advice$runWriteStudentAttendingCourse = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new WriteStudentAttendingCourse();
    }
}

