/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.department;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;
import org.fenixedu.academic.domain.curriculum.GradeFactory;
import org.fenixedu.academic.domain.curriculum.IGrade;
import org.fenixedu.academic.dto.department.CourseStatisticsDTO;

public abstract class ComputeCourseStatistics {
    protected GradeFactory gradeFactory = GradeFactory.getInstance();

    protected void createCourseStatistics(CourseStatisticsDTO courseStatistics, List<Enrolment> enrolments) {
        int firstEnrolledCount = 0;
        int firstApprovedCount = 0;
        ArrayList<IGrade> firstApprovedGrades = new ArrayList<IGrade>();
        int restEnrolledCount = 0;
        int restApprovedCount = 0;
        ArrayList<IGrade> restApprovedGrades = new ArrayList<IGrade>();
        int totalEnrolledCount = 0;
        int totalApprovedCount = 0;
        ArrayList<IGrade> totalApprovedGrades = new ArrayList<IGrade>();
        for (Enrolment enrolment : enrolments) {
            IGrade grade;
            ++totalEnrolledCount;
            EnrolmentEvaluation evaluation = this.getBestEnrollmentEvaluation(enrolment);
            if (enrolment.isFirstTime().booleanValue()) {
                ++firstEnrolledCount;
                if (evaluation == null || evaluation.getEnrollmentStateByGrade() != EnrollmentState.APROVED) continue;
                ++firstApprovedCount;
                grade = evaluation.getGradeWrapper();
                firstApprovedGrades.add(grade);
                totalApprovedGrades.add(grade);
                ++totalApprovedCount;
                continue;
            }
            ++restEnrolledCount;
            if (evaluation == null || evaluation.getEnrollmentStateByGrade() != EnrollmentState.APROVED) continue;
            ++restApprovedCount;
            grade = evaluation.getGradeWrapper();
            restApprovedGrades.add(grade);
            totalApprovedGrades.add(grade);
            ++totalApprovedCount;
        }
        IGrade firstApprovedAverage = this.calculateApprovedAverage(firstApprovedGrades);
        IGrade restApprovedAverage = this.calculateApprovedAverage(restApprovedGrades);
        IGrade totalApprovedAverage = this.calculateApprovedAverage(totalApprovedGrades);
        courseStatistics.setFirstEnrolledCount(firstEnrolledCount);
        courseStatistics.setFirstApprovedCount(firstApprovedCount);
        courseStatistics.setFirstApprovedAverage(firstApprovedAverage);
        courseStatistics.setRestEnrolledCount(restEnrolledCount);
        courseStatistics.setRestApprovedCount(restApprovedCount);
        courseStatistics.setRestApprovedAverage(restApprovedAverage);
        courseStatistics.setTotalEnrolledCount(totalEnrolledCount);
        courseStatistics.setTotalApprovedCount(totalApprovedCount);
        courseStatistics.setTotalApprovedAverage(totalApprovedAverage);
    }

    private IGrade calculateApprovedAverage(List<IGrade> approvedGrades) {
        if (approvedGrades.size() == 0) {
            return null;
        }
        return approvedGrades.iterator().next().getGradeType().average(approvedGrades);
    }

    protected EnrolmentEvaluation getBestEnrollmentEvaluation(Enrolment enrollment) {
        EnrolmentEvaluation best = null;
        for (EnrolmentEvaluation evaluation : enrollment.getEvaluationsSet()) {
            if (best != null && best.getGradeWrapper().compareTo(evaluation.getGradeWrapper()) <= 0) continue;
            best = evaluation;
        }
        return best;
    }
}

