/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.json.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.json.adapters.ShiftShortJsonAdapter;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.json.JsonViewer;

@DefaultJsonAdapter(value=Attends.class)
public class AttendsJsonAdapter
implements JsonViewer<Attends> {
    public JsonElement view(Attends attends, JsonBuilder ctx) {
        JsonObject object = new JsonObject();
        object.addProperty("externalId", attends.getExternalId());
        object.add("person", ctx.view((Object)attends.getRegistration().getPerson()));
        object.addProperty("number", (Number)attends.getRegistration().getNumber());
        object.add("studentGroups", ctx.view(attends.getStudentGroupsSet()));
        object.add("curricularPlan", ctx.view((Object)attends.getStudentCurricularPlanFromAttends().getDegreeCurricularPlan()));
        if (attends.getEnrolment() != null) {
            object.addProperty("enrolmentsInThisCourse", (Number)attends.getEnrolment().getNumberOfTotalEnrolmentsInThisCourse(attends.getEnrolment().getExecutionPeriod()));
        } else {
            object.addProperty("enrolmentsInThisCourse", "--");
        }
        RegistrationState registrationState = attends.getRegistration().getLastRegistrationState(attends.getExecutionYear());
        object.addProperty("registrationState", registrationState == null ? "" : registrationState.getStateType().getDescription());
        object.addProperty("enrolmentType", BundleUtil.getString((String)"resources.EnumerationResources", (String)attends.getAttendsStateType().getQualifiedName(), (String[])new String[0]));
        object.addProperty("workingStudent", Boolean.valueOf(attends.getRegistration().getStudent().hasWorkingStudentStatuteInPeriod(attends.getExecutionPeriod())));
        JsonObject shiftsByType = new JsonObject();
        attends.getExecutionCourse().getShiftTypes().forEach(shiftType -> {
            Shift shift = attends.getRegistration().getShiftFor(attends.getExecutionCourse(), (ShiftType)((Object)shiftType));
            if (shift != null) {
                shiftsByType.add(shiftType.getName(), ctx.view((Object)shift, ShiftShortJsonAdapter.class));
            } else {
                shiftsByType.add(shiftType.getName(), (JsonElement)new JsonObject());
            }
        });
        object.add("shifts", (JsonElement)shiftsByType);
        return object;
    }
}

