/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student.enrollment.bolonha;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumEnrolmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumGroupBean;

public class ImprovementStudentCurriculumGroupBean
extends StudentCurriculumGroupBean {
    private static final long serialVersionUID = 1L;

    public ImprovementStudentCurriculumGroupBean(CurriculumGroup curriculumGroup, ExecutionSemester executionSemester) {
        super(curriculumGroup, executionSemester, null);
    }

    @Override
    protected List<IDegreeModuleToEvaluate> buildCourseGroupsToEnrol(CurriculumGroup group, ExecutionSemester executionSemester) {
        return Collections.emptyList();
    }

    @Override
    protected List<StudentCurriculumEnrolmentBean> buildCurricularCoursesEnroled(CurriculumGroup group, ExecutionSemester executionSemester) {
        ArrayList<StudentCurriculumEnrolmentBean> result = new ArrayList<StudentCurriculumEnrolmentBean>();
        for (CurriculumModule curriculumModule : group.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!curriculumModule.isEnrolment() || !(enrolment = (Enrolment)((Object)curriculumModule)).isImprovementEnroled() || !enrolment.getExecutionPeriod().isBefore(executionSemester)) continue;
            result.add(new StudentCurriculumEnrolmentBean(enrolment));
        }
        return result;
    }

    @Override
    protected List<IDegreeModuleToEvaluate> buildCurricularCoursesToEnrol(CurriculumGroup group, ExecutionSemester executionSemester) {
        ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>();
        for (CurriculumModule curriculumModule : group.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!curriculumModule.isEnrolment() || !(enrolment = (Enrolment)((Object)curriculumModule)).canBeImproved() || !enrolment.getExecutionPeriod().isBefore(executionSemester)) continue;
            result.add(new EnroledCurriculumModuleWrapper((CurriculumModule)((Object)enrolment), enrolment.getExecutionPeriod()));
        }
        return result;
    }

    @Override
    protected List<StudentCurriculumGroupBean> buildCurriculumGroupsEnroled(CurriculumGroup parentGroup, ExecutionSemester executionSemester, int[] curricularYears) {
        ArrayList<StudentCurriculumGroupBean> result = new ArrayList<StudentCurriculumGroupBean>();
        for (CurriculumGroup curriculumGroup : parentGroup.getCurriculumGroupsToEnrolmentProcess()) {
            result.add(new ImprovementStudentCurriculumGroupBean(curriculumGroup, executionSemester));
        }
        return result;
    }

    @Override
    public List<IDegreeModuleToEvaluate> getSortedDegreeModulesToEvaluate() {
        ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>(this.getCurricularCoursesToEnrol());
        Collections.sort(result, IDegreeModuleToEvaluate.COMPARATOR_BY_EXECUTION_PERIOD);
        return result;
    }

    @Override
    public boolean isToBeDisabled() {
        return true;
    }
}

