/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourseScope;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.space.EventSpaceOccupation;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.dto.InfoCurricularCourseScope;
import org.fenixedu.academic.dto.InfoEvaluation;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoRoomOccupation;

public class InfoWrittenEvaluation
extends InfoEvaluation {
    protected WrittenEvaluation writtenEvaluation;
    protected Calendar day;
    protected Calendar beginning;
    protected Calendar end;
    protected Calendar enrollmentBeginDay;
    protected Calendar enrollmentEndDay;
    protected Calendar enrollmentBeginTime;
    protected Calendar enrollmentEndTime;
    protected List<InfoCurricularCourseScope> associatedCurricularCourseScope;
    protected List<InfoRoomOccupation> associatedRoomOccupation;
    protected List<InfoExecutionCourse> associatedExecutionCourse;
    protected Integer enrolledStudents;

    public List<InfoCurricularCourseScope> getAssociatedCurricularCourseScope() {
        return this.associatedCurricularCourseScope;
    }

    public List<InfoRoomOccupation> getWrittenEvaluationSpaceOccupations() {
        return this.associatedRoomOccupation;
    }

    public Calendar getBeginning() {
        return this.beginning;
    }

    public Calendar getDay() {
        return this.day;
    }

    public Calendar getEnd() {
        return this.end;
    }

    public Calendar getEnrollmentBeginDay() {
        return this.enrollmentBeginDay;
    }

    public Calendar getEnrollmentBeginTime() {
        return this.enrollmentBeginTime;
    }

    public Calendar getEnrollmentEndDay() {
        return this.enrollmentEndDay;
    }

    public Calendar getEnrollmentEndTime() {
        return this.enrollmentEndTime;
    }

    public void setAssociatedCurricularCourseScope(List<InfoCurricularCourseScope> list) {
        this.associatedCurricularCourseScope = list;
    }

    public void setWrittenEvaluationSpaceOccupations(List<InfoRoomOccupation> list) {
        this.associatedRoomOccupation = list;
    }

    public void setBeginning(Calendar calendar) {
        this.beginning = calendar;
    }

    public void setDay(Calendar calendar) {
        this.day = calendar;
    }

    public void setEnd(Calendar calendar) {
        this.end = calendar;
    }

    public void setEnrollmentBeginDay(Calendar calendar) {
        this.enrollmentBeginDay = calendar;
    }

    public void setEnrollmentBeginTime(Calendar calendar) {
        this.enrollmentBeginTime = calendar;
    }

    public void setEnrollmentEndDay(Calendar calendar) {
        this.enrollmentEndDay = calendar;
    }

    public void setEnrollmentEndTime(Calendar calendar) {
        this.enrollmentEndTime = calendar;
    }

    public List<InfoExecutionCourse> getAssociatedExecutionCourse() {
        return this.associatedExecutionCourse;
    }

    public void setAssociatedExecutionCourse(List<InfoExecutionCourse> list) {
        this.associatedExecutionCourse = list;
    }

    public Integer getEnrolledStudents() {
        return this.enrolledStudents;
    }

    public void setEnrolledStudents(Integer enrolledStudents) {
        this.enrolledStudents = enrolledStudents;
    }

    @Override
    public Calendar getInicio() {
        return this.getBeginning();
    }

    @Override
    public Calendar getFim() {
        return this.getEnd();
    }

    public void copyFromDomain(WrittenEvaluation writtenEvaluation) {
        super.copyFromDomain((Evaluation)((Object)writtenEvaluation));
        if (writtenEvaluation != null) {
            this.setWrittenEvaluation(writtenEvaluation);
            this.associatedExecutionCourse = new ArrayList<InfoExecutionCourse>();
            this.associatedRoomOccupation = new ArrayList<InfoRoomOccupation>();
            this.associatedCurricularCourseScope = new ArrayList<InfoCurricularCourseScope>();
            for (ExecutionCourse executionCourse : writtenEvaluation.getAssociatedExecutionCoursesSet()) {
                this.associatedExecutionCourse.add(InfoExecutionCourse.newInfoFromDomain(executionCourse));
            }
            for (WrittenEvaluationSpaceOccupation roomOccupation : writtenEvaluation.getWrittenEvaluationSpaceOccupationsSet()) {
                this.associatedRoomOccupation.add(InfoRoomOccupation.newInfoFromDomain((EventSpaceOccupation)((Object)roomOccupation)));
            }
            for (CurricularCourseScope curricularCourseScope : writtenEvaluation.getAssociatedCurricularCourseScopeSet()) {
                this.associatedCurricularCourseScope.add(InfoCurricularCourseScope.newInfoFromDomain(curricularCourseScope));
            }
            this.setBeginning(writtenEvaluation.getBeginning());
            this.setDay(writtenEvaluation.getDay());
            this.setEnd(writtenEvaluation.getEnd());
            this.setEnrollmentBeginDay(writtenEvaluation.getEnrollmentBeginDay());
            this.setEnrollmentBeginTime(writtenEvaluation.getEnrollmentBeginTime());
            this.setEnrollmentEndDay(writtenEvaluation.getEnrollmentEndDay());
            this.setEnrollmentEndTime(writtenEvaluation.getEnrollmentEndTime());
        }
    }

    public WrittenEvaluation getWrittenEvaluation() {
        return this.writtenEvaluation;
    }

    public void setWrittenEvaluation(WrittenEvaluation writtenEvaluation) {
        this.writtenEvaluation = writtenEvaluation;
    }
}

