/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.transactions;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.fenixedu.academic.domain.GratuitySituation;
import org.fenixedu.academic.domain.GuideEntry;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PersonAccount;
import org.fenixedu.academic.domain.reimbursementGuide.ReimbursementGuideEntry;
import org.fenixedu.academic.domain.transactions.GratuityTransaction;
import org.fenixedu.academic.domain.transactions.PaymentTransaction_Base;
import org.fenixedu.academic.domain.transactions.PaymentType;
import org.fenixedu.academic.domain.transactions.TransactionType;
import org.fenixedu.bennu.core.domain.Bennu;

public abstract class PaymentTransaction
extends PaymentTransaction_Base {
    public PaymentTransaction() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public PaymentTransaction(BigDecimal value, Timestamp transactionDate, String remarks, PaymentType paymentType, TransactionType transactionType, Boolean wasInternalBalance, Person responsiblePerson, PersonAccount personAccount, GuideEntry guideEntry) {
        this();
        this.setGuideEntry(guideEntry);
        this.setValueBigDecimal(value);
        this.setTransactionDate(transactionDate);
        this.setRemarks(remarks);
        this.setPaymentType(paymentType);
        this.setTransactionType(transactionType);
        this.setWasInternalBalance(wasInternalBalance);
        this.setResponsiblePerson(responsiblePerson);
        this.setPersonAccount(personAccount);
    }

    public void delete() {
        if (this instanceof GratuityTransaction) {
            GratuityTransaction gratuityTransaction = (GratuityTransaction)((Object)this);
            GratuitySituation gratuitySituation = gratuityTransaction.getGratuitySituation();
            gratuityTransaction.setGratuitySituation(null);
            gratuitySituation.updateValues();
        }
        this.setGuideEntry(null);
        super.delete();
    }

    public BigDecimal getValueWithAdjustment() {
        BigDecimal reimbursedValue = BigDecimal.ZERO;
        if (this.getGuideEntry() != null) {
            for (ReimbursementGuideEntry reimbursementGuideEntry : this.getGuideEntry().getReimbursementGuideEntriesSet()) {
                if (!reimbursementGuideEntry.getReimbursementGuide().isPayed()) continue;
                reimbursedValue = reimbursedValue.add(reimbursementGuideEntry.getValueBigDecimal());
            }
        }
        return this.getValueBigDecimal().subtract(reimbursedValue);
    }
}

