/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.Collection;
import java.util.HashSet;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Equivalence_Base;
import org.fenixedu.academic.dto.administrativeOffice.dismissal.DismissalBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class Equivalence
extends Equivalence_Base {
    public Equivalence() {
        this.setGrade(Grade.createEmptyGrade());
    }

    public Equivalence(StudentCurricularPlan studentCurricularPlan, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, Grade grade, ExecutionSemester executionSemester) {
        this();
        this.init(studentCurricularPlan, dismissals, enrolments, grade, executionSemester);
    }

    public Equivalence(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, Collection<IEnrolment> enrolments, Collection<CurricularCourse> noEnrolCurricularCourses, Double credits, Grade grade, ExecutionSemester executionSemester) {
        this();
        this.init(studentCurricularPlan, courseGroup, enrolments, noEnrolCurricularCourses, credits, grade, executionSemester);
    }

    public Equivalence(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, Collection<IEnrolment> enrolments, Double credits, Grade grade, ExecutionSemester executionSemester) {
        this();
        this.init(studentCurricularPlan, curriculumGroup, enrolments, new HashSet<CurricularCourse>(0), credits, grade, executionSemester);
    }

    protected void init(StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, Collection<IEnrolment> enrolments, Collection<CurricularCourse> noEnrolCurricularCourses, Double credits, Grade grade, ExecutionSemester executionSemester) {
        this.initGrade(enrolments, grade);
        super.init(studentCurricularPlan, courseGroup, enrolments, noEnrolCurricularCourses, credits, executionSemester);
    }

    protected void init(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, Collection<IEnrolment> enrolments, Collection<CurricularCourse> noEnrolCurricularCourses, Double credits, Grade grade, ExecutionSemester executionSemester) {
        this.initGrade(enrolments, grade);
        super.init(studentCurricularPlan, curriculumGroup, enrolments, noEnrolCurricularCourses, credits, executionSemester);
    }

    protected void init(StudentCurricularPlan studentCurricularPlan, Collection<DismissalBean.SelectedCurricularCourse> dismissals, Collection<IEnrolment> enrolments, Grade grade, ExecutionSemester executionSemester) {
        this.initGrade(enrolments, grade);
        super.init(studentCurricularPlan, dismissals, enrolments, executionSemester);
    }

    private void initGrade(Collection<IEnrolment> enrolments, Grade grade) {
        if (grade.isEmpty()) {
            throw new DomainException("error.equivalence.must.define.enrolments.and.grade", new String[0]);
        }
        this.setGrade(grade);
    }

    public String getGivenGrade() {
        return this.getGrade() != null ? this.getGrade().getValue() : null;
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.StudentResources", (String)"label.dismissal.Equivalence", (String[])new String[0]);
    }

    public boolean isCredits() {
        return false;
    }

    public boolean isEquivalence() {
        return true;
    }

    @ConsistencyPredicate
    protected boolean checkGrade() {
        return this.getGrade() != null;
    }
}

