/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.util.Optional;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.LocalDate;

public class RegistrationDataByExecutionYear
extends RegistrationDataByExecutionYear_Base {
    private RegistrationDataByExecutionYear(Registration registration, ExecutionYear executionYear) {
        this.setExecutionYear(executionYear);
        this.setRegistration(registration);
        this.setRootDomainObject(Bennu.getInstance());
        this.checkRules();
    }

    public void createReingression(LocalDate reingressionDate) {
        this.setReingression(true);
        this.setReingressionDate(reingressionDate);
        this.checkRules();
    }

    public void deleteReingression() {
        this.setReingression(false);
        this.setReingressionDate(null);
        this.checkRules();
    }

    protected void checkRules() {
        Optional<RegistrationDataByExecutionYear> result = this.getRegistration().getRegistrationDataByExecutionYearSet().stream().filter(registrationDataByExecutionYear -> registrationDataByExecutionYear.getExecutionYear() == this.getExecutionYear() && registrationDataByExecutionYear != this).findAny();
        if (result.isPresent()) {
            throw new DomainException("error.RegistrationDatByExecutionYear.executionYearShouldBeUnique", new String[0]);
        }
        if (this.isReingression()) {
            LocalDate reingressionDate = this.getReingressionDate();
            if (reingressionDate == null) {
                throw new DomainException("error.RegistrationDataByExecutionYear.reingressionDate.required", new String[0]);
            }
            if (!this.getExecutionYear().containsDate(reingressionDate)) {
                throw new DomainException("error.RegistrationDataByExecutionYear.reingressionDate.must.be.contained.in.executionYear", this.getExecutionYear().getName());
            }
        }
    }

    public boolean isReingression() {
        return this.getReingression();
    }

    public void delete() {
        this.setExecutionYear(null);
        this.setRegistration(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public static RegistrationDataByExecutionYear getOrCreateRegistrationDataByYear(Registration registration, ExecutionYear executionYear) {
        Optional<RegistrationDataByExecutionYear> result = registration.getRegistrationDataByExecutionYearSet().stream().filter(registrationDataByExecutionYear -> registrationDataByExecutionYear.getExecutionYear() == executionYear).findAny();
        return result.isPresent() ? result.get() : new RegistrationDataByExecutionYear(registration, executionYear);
    }

    public void edit(LocalDate enrolmentDate) {
        this.setEnrolmentDate(enrolmentDate);
        this.checkRules();
    }

    public LocalDate getEnrolmentDate() {
        return super.getEnrolmentDate();
    }

    public ExecutionYear getExecutionYear() {
        return super.getExecutionYear();
    }

    public Registration getRegistration() {
        return super.getRegistration();
    }
}

