/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.IProgramConclusionRequest;
import org.fenixedu.academic.domain.serviceRequests.RegistryCode;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DegreeFinalizationCertificateRequest$callable$revertToProcessingState;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DegreeFinalizationCertificateRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.PastDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.RegistryDiplomaRequest;
import org.fenixedu.academic.domain.student.MobilityProgram;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess_Base;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DegreeFinalizationCertificateRequest
extends DegreeFinalizationCertificateRequest_Base
implements IProgramConclusionRequest {
    public static final Advice advice$revertToProcessingState = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected DegreeFinalizationCertificateRequest() {
    }

    public DegreeFinalizationCertificateRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.setAverage(bean.getAverage());
        super.setMobilityProgram(bean.getMobilityProgram());
        super.setIgnoreExternalEntries(Boolean.valueOf(bean.isIgnoreExternalEntries()));
        super.setIgnoreCurriculumInAdvance(Boolean.valueOf(bean.isIgnoreCurriculumInAdvance()));
        super.setTechnicalEngineer(bean.getTechnicalEngineer());
        super.setInternshipAbolished(bean.getInternshipAbolished());
        super.setInternshipApproved(bean.getInternshipApproved());
        super.setStudyPlan(bean.getStudyPlan());
        super.setBranch(bean.getBranchName());
        super.setExceptionalConclusionDate(bean.getExceptionalConclusionDate());
        super.setLanguage(bean.getLanguage());
        super.setProgramConclusion(bean.getProgramConclusion());
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getAverage() == null) {
            throw new DomainException("DegreeFinalizationCertificateRequest.average.cannot.be.null", new String[0]);
        }
        if (bean.getDetailed() == null) {
            throw new DomainException("DegreeFinalizationCertificateRequest.detailed.cannot.be.null", new String[0]);
        }
        if (bean.getMobilityProgram() != null && bean.isIgnoreExternalEntries()) {
            throw new DomainException("ApprovementCertificateRequest.cannot.ignore.external.entries.within.a.mobility.program", new String[0]);
        }
        if ((bean.getInternshipAbolished().booleanValue() || bean.getInternshipApproved().booleanValue() || bean.getStudyPlan().booleanValue()) && bean.getExceptionalConclusionDate() == null) {
            throw new DomainException("DegreeFinalizationCertificateRequest.must.indicate.date.for.exceptional.conclusion.situation", new String[0]);
        }
        if (bean.getLanguage() == null) {
            throw new DomainException("DegreeFinalizationCertificateRequest.missing.language", new String[0]);
        }
        if (bean.getProgramConclusion() == null) {
            throw new DomainException("error.program.conclusion.empty", new String[0]);
        }
        this.checkSpecificConditions(bean.getProgramConclusion());
    }

    protected void checkSpecificConditions(ProgramConclusion programConclusion) {
        if (!programConclusion.getGraduationTitle().isEmpty()) {
            DegreeFinalizationCertificateRequest.checkForDiplomaRequest(this.getRegistration(), programConclusion);
        } else if (!programConclusion.isConclusionProcessed(this.getRegistration())) {
            throw new DomainException("DiplomaRequest.registration.not.submited.to.conclusion.process", new String[0]);
        }
    }

    public static void checkForDiplomaRequest(Registration registration, ProgramConclusion programConclusion) {
        DiplomaRequest diplomaRequest = registration.getDiplomaRequest(programConclusion);
        PastDiplomaRequest pastDiplomaRequest = registration.getPastDiplomaRequest();
        if (diplomaRequest == null && pastDiplomaRequest == null) {
            DegreeFinalizationCertificateRequest.checkForRegistryRequest(registration, programConclusion);
        }
    }

    public static void checkForRegistryRequest(Registration registration, ProgramConclusion programConclusion) {
        RegistryDiplomaRequest registryRequest = registration.getRegistryDiplomaRequest(programConclusion);
        if (registryRequest == null) {
            throw new DomainException("DegreeFinalizationCertificateRequest.registration.withoutRegistryRequest", new String[0]);
        }
    }

    protected final void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        if (academicServiceRequestBean.isToProcess()) {
            this.checkSpecificConditions(this.getProgramConclusion());
            if (!this.getProgramConclusion().isConclusionProcessed(this.getRegistration())) {
                throw new DomainException("DegreeFinalizationCertificateRequest.registration.not.submited.to.conclusion.process", new String[0]);
            }
            RegistryDiplomaRequest registryRequest = this.getRegistration().getRegistryDiplomaRequest(this.getProgramConclusion());
            if (registryRequest != null && registryRequest.getAcademicServiceRequestSituationType().compareTo(AcademicServiceRequestSituationType.SENT_TO_EXTERNAL_ENTITY) < 0) {
                throw new DomainException("DegreeFinalizationCertificateRequest.registration.registryRequestIsNotSentToExternalEntity", new String[0]);
            }
            if (this.hasPersonalInfo() && this.hasMissingPersonalInfo()) {
                throw new DomainException("AcademicServiceRequest.has.missing.personal.info", new String[0]);
            }
        }
        if (academicServiceRequestBean.isToConclude()) {
            this.tryConcludeServiceRequest(academicServiceRequestBean);
        }
    }

    @Override
    public final String getDescription() {
        return Joiner.on((String)" : ").join((Object)BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getDocumentRequestType().name(), (String[])new String[0]), (Object)this.getProgramConclusion().getName().getContent(), new Object[0]);
    }

    @Override
    public final DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.DEGREE_FINALIZATION_CERTIFICATE;
    }

    @Override
    public final String getDocumentTemplateKey() {
        return this.getClass().getName();
    }

    public final void setAverage(Boolean average) {
        throw new DomainException("DegreeFinalizationCertificateRequest.cannot.modify.average", new String[0]);
    }

    public final void setDetailed(Boolean detailed) {
        throw new DomainException("DegreeFinalizationCertificateRequest.cannot.modify.detailed", new String[0]);
    }

    public void setMobilityProgram(MobilityProgram mobilityProgram) {
        throw new DomainException("error.DegreeFinalizationCertificateRequest.cannot.modify", new String[0]);
    }

    public void setIgnoreExternalEntries(Boolean ignoreExternalEntries) {
        throw new DomainException("error.DegreeFinalizationCertificateRequest.cannot.modify", new String[0]);
    }

    public void setTechnicalEngineer(Boolean technicalEngineer) {
        throw new DomainException("error.DegreeFinalizationCertificateRequest.cannot.modify", new String[0]);
    }

    public void setInternshipAbolished(Boolean internshipAbolished) {
        throw new DomainException("error.DegreeFinalizationCertificateRequest.cannot.modify", new String[0]);
    }

    public void setInternshipApproved(Boolean internshipApproved) {
        throw new DomainException("error.DegreeFinalizationCertificateRequest.cannot.modify", new String[0]);
    }

    public void setExceptionalConclusionDate(YearMonthDay exceptionalConclusionDate) {
        throw new DomainException("error.DegreeFinalizationCertificateRequest.cannot.modify", new String[0]);
    }

    public void setStudyPlan(Boolean studyPlan) {
        throw new DomainException("error.DegreeFinalizationCertificateRequest.cannot.modify", new String[0]);
    }

    @Override
    public CycleType getRequestedCycle() {
        return this.getProgramConclusion().groupFor(this.getRegistration()).filter(CurriculumModule::isCycleCurriculumGroup).map(ccg -> ((CycleCurriculumGroup)((Object)((Object)ccg))).getCycleType()).orElse(null);
    }

    public static Set<EventType> getPossibleEventTypes() {
        return ImmutableSet.of((Object)((Object)EventType.DEGREE_FINALIZATION_CERTIFICATE_REQUEST));
    }

    @Override
    public final EventType getEventType() {
        return EventType.DEGREE_FINALIZATION_CERTIFICATE_REQUEST;
    }

    @Override
    public final Integer getNumberOfUnits() {
        return this.getDetailed() != false ? this.getEntriesToReport().size() : 0;
    }

    private final RegistrationConclusionBean getBean() {
        return new RegistrationConclusionBean(this.getRegistration(), this.getProgramConclusion());
    }

    public final boolean hasExceptionalConclusionDate() {
        return this.getExceptionalConclusionDate() != null;
    }

    public final boolean hasExceptionalConclusionInfo() {
        return this.getTechnicalEngineer() != false || this.getInternshipAbolished() != false || this.getInternshipApproved() != false || this.getStudyPlan() != false;
    }

    public final boolean mustHideConclusionDate() {
        return this.getInternshipAbolished() != false || this.getInternshipApproved() != false || this.getStudyPlan() != false && this.getRegistration().isFirstCycleAtributionIngression();
    }

    public final YearMonthDay getConclusionDate() {
        return this.getBean().getConclusionDate();
    }

    public final Integer getFinalAverage() {
        return this.getBean().getFinalGrade().getIntegerValue();
    }

    public final double getEctsCredits() {
        return this.getBean().getEctsCredits();
    }

    public final ICurriculum getCurriculum() {
        return this.getBean().getCurriculumForConclusion();
    }

    public final Collection<ICurriculumEntry> getEntriesToReport() {
        HashSet<ICurriculumEntry> result = new HashSet<ICurriculumEntry>();
        for (ICurriculumEntry entry : this.getCurriculum().getCurriculumEntries()) {
            Dismissal dismissal;
            if (entry instanceof Dismissal && ((dismissal = (Dismissal)entry).getCredits().isEquivalence() || dismissal.isCreditsDismissal() && !dismissal.getCredits().isSubstitution())) continue;
            result.add(entry);
        }
        return result;
    }

    public boolean hasPersonalInfo() {
        return true;
    }

    @Override
    public RegistryCode getRegistryCode() {
        RegistryDiplomaRequest registry = this.getRegistration().getRegistryDiplomaRequest(this.getProgramConclusion());
        return registry != null ? registry.getRegistryCode() : null;
    }

    public void revertToProcessingState() {
        Object object = advice$revertToProcessingState.perform((Callable)new DegreeFinalizationCertificateRequest$callable$revertToProcessingState(this));
    }

    static /* synthetic */ void advised$revertToProcessingState(DegreeFinalizationCertificateRequest this_) {
        AccessControl.check(this_, AcademicPredicates.SERVICE_REQUESTS_REVERT_TO_PROCESSING_STATE);
        this_.internalRevertToProcessingState();
    }

    protected void createCertificateRequestEvent() {
    }

    public ExecutionYear getConclusionYear() {
        return this.getProgramConclusion().groupFor(this.getRegistration()).map(CurriculumGroup::getConclusionProcess).map(ConclusionProcess_Base::getConclusionYear).orElse(null);
    }

    @Override
    public String getGraduateTitle(Locale locale) {
        StringBuilder res = new StringBuilder();
        if (!this.getProgramConclusion().getGraduationTitle().isEmpty()) {
            res.append(", ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLanguage(), (String)"documents.DegreeFinalizationCertificate.graduateTitleInfo", (String[])new String[0]));
            res.append(" ").append(this.getRegistration().getGraduateTitle(this.getProgramConclusion(), this.getLanguage()));
        }
        return res.toString();
    }
}

