/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import java.util.Comparator;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituation_Base;
import org.fenixedu.academic.domain.serviceRequests.ReceivedFromExternalEntityAcademicServiceRequestSituation;
import org.fenixedu.academic.domain.serviceRequests.SentToExternalEntityAcademicServiceRequestSituation;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import pt.ist.fenixframework.DomainObject;

public class AcademicServiceRequestSituation
extends AcademicServiceRequestSituation_Base {
    public static Comparator<AcademicServiceRequestSituation> COMPARATOR_BY_MOST_RECENT_SITUATION_DATE_AND_ID = new Comparator<AcademicServiceRequestSituation>(){

        @Override
        public int compare(AcademicServiceRequestSituation leftAcademicServiceRequestSituation, AcademicServiceRequestSituation rightAcademicServiceRequestSituation) {
            int comparationResult;
            DateTime leftDate = leftAcademicServiceRequestSituation.getSituationDate();
            DateTime rightDate = rightAcademicServiceRequestSituation.getSituationDate();
            if (leftDate == null) {
                leftDate = leftAcademicServiceRequestSituation.getCreationDate();
            }
            if (rightDate == null) {
                rightDate = rightAcademicServiceRequestSituation.getCreationDate();
            }
            return -((comparationResult = leftDate.compareTo((ReadableInstant)rightDate)) == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)leftAcademicServiceRequestSituation, (DomainObject)rightAcademicServiceRequestSituation) : comparationResult);
        }
    };

    protected AcademicServiceRequestSituation() {
        super.setRootDomainObject(Bennu.getInstance());
        super.setCreationDate(new DateTime());
    }

    private AcademicServiceRequestSituation(AcademicServiceRequest academicServiceRequest, AcademicServiceRequestBean academicServiceRequestBean) {
        this();
        this.init(academicServiceRequest, academicServiceRequestBean);
    }

    protected void init(AcademicServiceRequest academicServiceRequest, AcademicServiceRequestBean academicServiceRequestBean) {
        this.checkParameters(academicServiceRequest, academicServiceRequestBean);
        super.setAcademicServiceRequest(academicServiceRequest);
        super.setAcademicServiceRequestSituationType(academicServiceRequestBean.getAcademicServiceRequestSituationType());
        super.setCreator(academicServiceRequestBean.getResponsible());
        super.setJustification(academicServiceRequestBean.hasJustification() ? academicServiceRequestBean.getJustification() : null);
        super.setSituationDate(academicServiceRequestBean.getFinalSituationDate());
    }

    protected void checkParameters(AcademicServiceRequest academicServiceRequest, AcademicServiceRequestBean bean) {
        if (academicServiceRequest == null) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequestSituation.academicServiceRequest.cannot.be.null", new String[0]);
        }
        if (!bean.hasAcademicServiceRequestSituationType()) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequestSituation.academicServiceRequestSituationType.cannot.be.null", new String[0]);
        }
        AcademicServiceRequestSituation activeSituation = academicServiceRequest.getActiveSituation();
        if (activeSituation != null) {
            DateTime activeSituationDate = activeSituation.getSituationDate();
            DateTime finalSituationDate = bean.getFinalSituationDate();
            if (finalSituationDate.toLocalDate().isBefore((ReadablePartial)activeSituationDate.toLocalDate())) {
                throw new DomainException("error.serviceRequests.AcademicServiceRequestSituation.situation.date.is.before", new String[0]);
            }
            if (finalSituationDate.toLocalDate().isEqual((ReadablePartial)activeSituationDate.toLocalDate()) && finalSituationDate.isBefore((ReadableInstant)activeSituationDate)) {
                bean.setFinalSituationDate(activeSituationDate.plusMinutes(1));
            }
        }
        if (bean.getFinalSituationDate().isAfterNow()) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequestSituation.situation.date.is.after", new String[0]);
        }
        if (bean.isToCancelOrReject() && !bean.hasJustification()) {
            throw new DomainException("error.serviceRequests.AcademicServiceRequestSituation.justification.cannot.be.null.for.cancelled.and.rejected.situations", new String[0]);
        }
    }

    public void setAcademicServiceRequest(AcademicServiceRequest academicServiceRequest) {
        throw new DomainException("error.serviceRequests.AcademicServiceRequestSituation.cannot.modify.academicServiceRequest", new String[0]);
    }

    public void setCreator(Person reponsible) {
        throw new DomainException("error.serviceRequests.AcademicServiceRequestSituation.cannot.modify.creator", new String[0]);
    }

    public void setAcademicServiceRequestSituationType(AcademicServiceRequestSituationType academicServiceRequestSituationType) {
        throw new DomainException("error.serviceRequests.AcademicServiceRequestSituation.cannot.modify.academicServiceRequestSituationType", new String[0]);
    }

    public void setCreationDate(DateTime creationDate) {
        throw new DomainException("error.serviceRequests.AcademicServiceRequestSituation.cannot.modify.creationDate", new String[0]);
    }

    public void setJustification(String justification) {
        throw new DomainException("error.serviceRequests.AcademicServiceRequestSituation.cannot.modify.justification", new String[0]);
    }

    public boolean isDelivered() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.DELIVERED;
    }

    public boolean isNew() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.NEW;
    }

    public boolean isProcessing() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.PROCESSING;
    }

    public boolean isCancelled() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.CANCELLED;
    }

    public boolean isSentToExternalEntity() {
        return this.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.SENT_TO_EXTERNAL_ENTITY;
    }

    void edit(AcademicServiceRequestBean academicServiceRequestBean) {
        super.setCreator(academicServiceRequestBean.getResponsible());
        super.setJustification(academicServiceRequestBean.getJustification());
    }

    public void delete() {
        this.delete(true);
    }

    public void delete(boolean checkRules) {
        if (checkRules) {
            this.checkRulesToDelete();
        }
        super.setRootDomainObject(null);
        super.setCreator(null);
        super.setAcademicServiceRequest(null);
        super.deleteDomainObject();
    }

    protected void checkRulesToDelete() {
        if (this.isDelivered()) {
            throw new DomainException("AcademicServiceRequestSituation.already.delivered", new String[0]);
        }
    }

    public DateTime getFinalSituationDate() {
        return this.getSituationDate();
    }

    static AcademicServiceRequestSituation create(AcademicServiceRequest academicServiceRequest, AcademicServiceRequestBean academicServiceRequestBean) {
        Object situation = null;
        switch (academicServiceRequestBean.getAcademicServiceRequestSituationType()) {
            case SENT_TO_EXTERNAL_ENTITY: {
                situation = new SentToExternalEntityAcademicServiceRequestSituation(academicServiceRequest, academicServiceRequestBean);
            }
            case RECEIVED_FROM_EXTERNAL_ENTITY: {
                situation = new ReceivedFromExternalEntityAcademicServiceRequestSituation(academicServiceRequest, academicServiceRequestBean);
            }
        }
        situation = new AcademicServiceRequestSituation(academicServiceRequest, academicServiceRequestBean);
        return situation;
    }
}

