/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.residence;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.organizationalStructure.ResidenceManagementUnit;
import org.fenixedu.academic.domain.residence.ResidenceMonth;
import org.fenixedu.academic.domain.residence.ResidenceYear_Base;
import org.fenixedu.academic.util.Month;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class ResidenceYear
extends ResidenceYear_Base {
    public ResidenceYear(ResidenceManagementUnit residenceManagementUnit) {
        this(ResidenceYear.getNextYear(), residenceManagementUnit);
    }

    public ResidenceYear(Integer year, ResidenceManagementUnit residenceManagementUnit) {
        this.setYear(year);
        this.setUnit(residenceManagementUnit);
        this.setRootDomainObject(Bennu.getInstance());
        for (Month month : Month.values()) {
            new ResidenceMonth(month, this);
        }
    }

    public Set<ResidenceMonth> getSortedMonths() {
        TreeSet<ResidenceMonth> months = new TreeSet<ResidenceMonth>((Comparator<ResidenceMonth>)new BeanComparator("month"));
        months.addAll(this.getMonthsSet());
        return months;
    }

    private static Integer getNextYear() {
        Integer next = null;
        for (ResidenceYear year : Bennu.getInstance().getResidenceYearsSet()) {
            if (next != null && year.getYear() <= next) continue;
            next = year.getYear();
        }
        return next != null ? next + 1 : new DateTime().getYear();
    }

    public static ResidenceYear getCurrentYear() {
        Integer currentYear = new LocalDate().getYear();
        for (ResidenceYear year : Bennu.getInstance().getResidenceYearsSet()) {
            if (!year.getYear().equals(currentYear)) continue;
            return year;
        }
        return null;
    }

    public static boolean hasCurrentYear() {
        return ResidenceYear.getCurrentYear() != null;
    }

    public boolean isFor(int year) {
        return this.getYear() == year;
    }
}

