/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.reports.GepReportFile;
import org.fenixedu.academic.domain.reports.WrittenEvaluationReportFile_Base;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.spaces.domain.Space;

public class WrittenEvaluationReportFile
extends WrittenEvaluationReportFile_Base {
    public String getJobName() {
        return "Listagem de Avaliacoes Escritas";
    }

    protected String getPrefix() {
        return "writtenEvaluations";
    }

    public void renderReport(Spreadsheet spreadsheet) throws Exception {
        spreadsheet.setHeader("Ano Lectivo");
        spreadsheet.setHeader("Semestre");
        spreadsheet.setHeader("C\u00f3digo Execu\u00e7\u00e3o Disciplina");
        spreadsheet.setHeader("Nome da Disciplina");
        spreadsheet.setHeader("C\u00f3digo Avalia\u00e7\u00e3o");
        spreadsheet.setHeader("Tipo de Avalia\u00e7\u00e3o");
        spreadsheet.setHeader("Data Avalia\u00e7\u00e3o");
        spreadsheet.setHeader("Hora de In\u00edcio");
        spreadsheet.setHeader("Hora de Fim");
        spreadsheet.setHeader("Salas");
        spreadsheet.setHeader("Capacidade Exame");
        spreadsheet.setHeader("Capacidade Normal");
        spreadsheet.setHeader("N\u00famero de Inscritos");
        for (ExecutionSemester executionSemester : this.getExecutionYear().getExecutionPeriodsSet()) {
            for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
                for (Evaluation evaluation : executionCourse.getAssociatedEvaluationsSet()) {
                    if (!(evaluation instanceof WrittenEvaluation)) continue;
                    WrittenEvaluation writtenEvaluation = (WrittenEvaluation)((Object)evaluation);
                    Spreadsheet.Row row = spreadsheet.addRow();
                    row.setCell(this.getExecutionYear().getYear());
                    row.setCell(executionSemester.getSemester());
                    row.setCell(GepReportFile.getExecutionCourseCode(executionCourse));
                    row.setCell(executionCourse.getName());
                    row.setCell(GepReportFile.getWrittenEvaluationCode(writtenEvaluation));
                    row.setCell(writtenEvaluation instanceof Exam ? "Exame" : "Teste");
                    row.setCell(writtenEvaluation.getDayDateYearMonthDay().toString("yyyy-MM-dd"));
                    row.setCell(writtenEvaluation.getBeginningDateTime().toString("HH:mm"));
                    row.setCell(writtenEvaluation.getEndDateTime().toString("HH:mm"));
                    StringBuilder rooms = new StringBuilder();
                    int examVacancy = 0;
                    int normalVacancy = 0;
                    for (WrittenEvaluationSpaceOccupation roomOccupation : writtenEvaluation.getWrittenEvaluationSpaceOccupationsSet()) {
                        Space room = roomOccupation.getRoom();
                        if (rooms.length() > 0) {
                            rooms.append(", ");
                        }
                        rooms.append(room.getName());
                        examVacancy += room.getMetadata("examCapacity").orElse(0).intValue();
                        normalVacancy += room.getAllocatableCapacity().intValue();
                    }
                    row.setCell(rooms.toString());
                    row.setCell(Integer.valueOf(examVacancy));
                    row.setCell(Integer.valueOf(normalVacancy));
                    if (writtenEvaluation.getEnrollmentBeginDayDateYearMonthDay() == null) {
                        row.setCell(" ");
                        continue;
                    }
                    int enrolmentCount = writtenEvaluation.getWrittenEvaluationEnrolmentsSet().size();
                    row.setCell(Integer.valueOf(enrolmentCount));
                }
            }
        }
    }
}

