/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.meeting;

import java.util.List;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.PhdProgramProcess;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcess;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcessState_Base;
import org.joda.time.DateTime;

public class PhdMeetingSchedulingProcessState
extends PhdMeetingSchedulingProcessState_Base {
    public PhdMeetingSchedulingProcessState() {
    }

    protected PhdMeetingSchedulingProcessState(PhdMeetingSchedulingProcess process2, PhdMeetingSchedulingProcessStateType type, Person person, String remarks, DateTime stateDate) {
        this();
        this.checkType(process2, type);
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.PhdMeetingSchedulingProcessState.invalid.process", args);
        }
        String[] args1 = new String[]{};
        if (type == null) {
            throw new DomainException("error.PhdMeetingSchedulingProcessState.invalid.type", args1);
        }
        this.setMeetingProcess(process2);
        super.init(person, remarks, stateDate, (PhdProcessStateType)type);
        this.setType(type);
    }

    protected void init(Person person, String remarks, DateTime stateDate) {
        throw new RuntimeException("invoke other init");
    }

    private void checkType(PhdMeetingSchedulingProcess process2, PhdMeetingSchedulingProcessStateType type) {
        PhdMeetingSchedulingProcessStateType currentType = process2.getActiveState();
        if (currentType != null && currentType.equals(type)) {
            throw new PhdDomainOperationException("error.PhdMeetingSchedulingProcessState.equals.previous.state", type.getLocalizedName());
        }
    }

    protected void disconnect() {
        this.setMeetingProcess(null);
        super.disconnect();
    }

    public boolean isLast() {
        return this.getMeetingProcess().getMostRecentState() == this;
    }

    public static PhdMeetingSchedulingProcessState createWithInferredStateDate(PhdMeetingSchedulingProcess process2, PhdMeetingSchedulingProcessStateType type, Person person, String remarks) {
        DateTime stateDate = null;
        PhdMeetingSchedulingProcessState mostRecentState = process2.getMostRecentState();
        switch (type) {
            case WAITING_FIRST_THESIS_MEETING_REQUEST: {
                if (process2.getThesisProcess().getWhenJuryValidated() == null) {
                    throw new PhdDomainOperationException("error.phd.thesis.meeting.PhdMeetingSchedulingProcessState.whenJuryValidated.required", new String[0]);
                }
                stateDate = process2.getThesisProcess().getWhenJuryValidated().toDateTimeAtStartOfDay();
                break;
            }
            case WAITING_FIRST_THESIS_MEETING_SCHEDULE: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
                break;
            }
            case WAITING_THESIS_MEETING_SCHEDULE: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
                break;
            }
            case WITHOUT_THESIS_MEETING_REQUEST: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
            }
        }
        return PhdMeetingSchedulingProcessState.createWithGivenStateDate(process2, type, person, remarks, stateDate);
    }

    public static PhdMeetingSchedulingProcessState createWithGivenStateDate(PhdMeetingSchedulingProcess process2, PhdMeetingSchedulingProcessStateType type, Person person, String remarks, DateTime stateDate) {
        List<PhdMeetingSchedulingProcessStateType> possibleNextStates = PhdMeetingSchedulingProcessStateType.getPossibleNextStates(process2);
        String expectedStatesDescription = PhdMeetingSchedulingProcessState.buildExpectedStatesDescription(possibleNextStates);
        if (!possibleNextStates.contains(type)) {
            throw new PhdDomainOperationException("error.phd.thesis.meeting.PhdMeetingSchedulingProcessState.invalid.next.state", type.getLocalizedName(), expectedStatesDescription);
        }
        return new PhdMeetingSchedulingProcessState(process2, type, person, remarks, stateDate);
    }

    public PhdProgramProcess getProcess() {
        return this.getMeetingProcess();
    }
}

