/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.debts;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.events.ExemptionJustification;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.phd.debts.ExternalScholarshipPhdGratuityContribuitionEvent;
import org.fenixedu.academic.domain.phd.debts.PhdEventExemption;
import org.fenixedu.academic.domain.phd.debts.PhdEventExemptionJustification;
import org.fenixedu.academic.domain.phd.debts.PhdEventExemptionJustificationType;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityEvent;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityExternalScholarshipExemption$callable$createPhdGratuityExternalScholarshipExemption;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityExternalScholarshipExemption_Base;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdGratuityExternalScholarshipExemption
extends PhdGratuityExternalScholarshipExemption_Base {
    public static final Advice advice$createPhdGratuityExternalScholarshipExemption = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public PhdGratuityExternalScholarshipExemption(Person responsible, Event event, Party party, Money value) {
        PhdEventExemptionJustification exemptionJustification = new PhdEventExemptionJustification((PhdEventExemption)((Object)this), PhdEventExemptionJustificationType.PHD_GRATUITY_FCT_SCHOLARSHIP_EXEMPTION, event.getWhenOccured().toLocalDate(), "Criado pela existencia de bolsa de entidade externa.");
        super.init(responsible, event, (ExemptionJustification)((Object)exemptionJustification));
        this.setParty(party);
        this.createExternalDebt();
        this.setValue(value);
        this.setRootDomainObject(Bennu.getInstance());
        event.recalculateState(new DateTime());
    }

    private void createExternalDebt() {
        ExternalScholarshipPhdGratuityContribuitionEvent event = new ExternalScholarshipPhdGratuityContribuitionEvent(this.getParty());
        this.setExternalScholarshipPhdGratuityContribuitionEvent(event);
    }

    public static PhdGratuityExternalScholarshipExemption createPhdGratuityExternalScholarshipExemption(Person person, Money money, Party party, PhdGratuityEvent phdGratuityEvent) {
        return (PhdGratuityExternalScholarshipExemption)((Object)advice$createPhdGratuityExternalScholarshipExemption.perform((Callable)new PhdGratuityExternalScholarshipExemption$callable$createPhdGratuityExternalScholarshipExemption(person, money, party, phdGratuityEvent)));
    }

    static /* synthetic */ PhdGratuityExternalScholarshipExemption advised$createPhdGratuityExternalScholarshipExemption(Person responsible, Money value, Party party, PhdGratuityEvent event) {
        if (event.hasExemptionsOfType(PhdGratuityExternalScholarshipExemption.class)) {
            throw new DomainException("error.already.has.scolarship", new String[0]);
        }
        PhdGratuityExternalScholarshipExemption phdGratuityExternalScholarshipExemption = new PhdGratuityExternalScholarshipExemption(responsible, (Event)((Object)event), party, value);
        return phdGratuityExternalScholarshipExemption;
    }

    public LabelFormatter getDescription() {
        PhdGratuityEvent event = (PhdGratuityEvent)((Object)this.getEvent());
        return new LabelFormatter().appendLabel("Bolsa de entidade externa (" + this.getParty().getName() + ") aplicada \u00e0 Propina do Programa de Doutoramento de ").appendLabel(event.getPhdProgram().getName().getContent()).appendLabel(" referente a " + event.getYear());
    }

    public void doDelete() {
        this.setExternalScholarshipPhdGratuityContribuitionEvent(null);
        this.setParty(null);
        super.delete();
    }

    public void delete() {
        ExternalScholarshipPhdGratuityContribuitionEvent event = this.getExternalScholarshipPhdGratuityContribuitionEvent();
        event.delete();
    }

    public Money getAmoutStillMissing() {
        return this.getExternalScholarshipPhdGratuityContribuitionEvent().calculateAmountToPay();
    }
}

