/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.alert;

import java.util.Collections;
import java.util.Locale;
import org.fenixedu.academic.domain.phd.InternalPhdParticipant;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.alert.PhdAlertMessage;
import org.fenixedu.academic.domain.phd.alert.PhdReporterReviewAlert_Base;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

public class PhdReporterReviewAlert
extends PhdReporterReviewAlert_Base {
    private static final int DAYS_UNTIL_WARNING = 35;
    private static final int DAYS_UNTIL_DEADLINE = 40;

    public PhdReporterReviewAlert(PhdIndividualProgramProcess process2, PhdParticipant participant) {
        super.init(process2, this.buildSubject(process2), this.buildBody(process2, participant));
        this.setPhdParticipant(participant);
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.request.reminder.jury.reviews.report.description", (String[])new String[0]);
    }

    protected boolean isToDiscard() {
        if (this.getFireDate() != null) {
            return true;
        }
        PhdProgramProcessDocument feedbackDocument = this.getProcess().getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.JURY_REPORT_FEEDBACK);
        return feedbackDocument != null && feedbackDocument.getCreationDate().isAfter((ReadableInstant)this.getWhenCreated());
    }

    protected boolean isToFire() {
        if (!this.hasExceededAlertDate()) {
            return false;
        }
        return this.getFireDate() == null;
    }

    private boolean hasExceededAlertDate() {
        return !new LocalDate().isBefore((ReadablePartial)this.getLimitDateForAlert());
    }

    private LocalDate getLimitDateForAlert() {
        return this.getProcess().getThesisProcess().getWhenJuryValidated().plusDays(35);
    }

    private int getDaysLeftUntilDeadline(PhdIndividualProgramProcess process2) {
        return Days.daysBetween((ReadablePartial)new LocalDate(), (ReadablePartial)this.getLimitDateForDeadline(process2)).getDays();
    }

    private LocalDate getLimitDateForDeadline(PhdIndividualProgramProcess process2) {
        return process2.getThesisProcess().getWhenJuryValidated().plusDays(40);
    }

    protected void generateMessage() {
        this.generateMessageForReporters();
    }

    private MultiLanguageString buildSubject(PhdIndividualProgramProcess process2) {
        return new MultiLanguageString(Locale.getDefault(), AlertService.AlertMessage.get("message.phd.request.jury.reviews.external.access.subject", process2.getPhdProgram().getName()));
    }

    private MultiLanguageString buildBody(PhdIndividualProgramProcess process2, PhdParticipant participant) {
        return new MultiLanguageString(Locale.getDefault(), AlertService.AlertMessage.get("message.phd.request.reminder.jury.reviews.reporter.body", process2.getPerson().getName(), process2.getProcessNumber(), this.getDaysLeftUntilDeadline(process2)) + "\n\n" + PhdThesisActivity.getAccessInformation(process2, participant, "message.phd.request.jury.reviews.coordinator.access", "message.phd.request.jury.reviews.teacher.access"));
    }

    private void generateMessageForReporters() {
        PhdParticipant participant = this.getPhdParticipant();
        if (participant.isInternal()) {
            InternalPhdParticipant internalParticipant = (InternalPhdParticipant)((Object)participant);
            new PhdAlertMessage(this.getProcess(), internalParticipant.getPerson(), this.getFormattedSubject(), this.buildBody(this.getProcess(), participant));
            new Message((Sender)((Object)this.getSender()), new Recipient(Collections.singleton(internalParticipant.getPerson())), this.buildMailSubject(), this.buildMailBody());
        } else {
            new Message((Sender)((Object)this.getSender()), Collections.emptyList(), Collections.emptyList(), this.buildMailSubject(), this.buildMailBody(), Collections.singleton(participant.getEmail()));
        }
    }

    public boolean isToSendMail() {
        return true;
    }

    public static int getReporterReviewDeadlineDays() {
        return 40;
    }
}

