/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.alert;

import java.io.Serializable;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.LocalDate;

public class PhdCustomAlertBean
implements Serializable {
    private static final long serialVersionUID = -3274906509546432695L;
    private PhdAlertTargetGroupType targetGroupType;
    private String subject;
    private String body;
    private boolean toSendEmail;
    private LocalDate fireDate;
    private Person personToAdd;
    private Boolean userDefined = true;
    private Boolean shared = false;
    private PhdIndividualProgramProcess process;
    private Group targetGroup;

    public PhdCustomAlertBean(PhdIndividualProgramProcess process2) {
        this.setProcess(process2);
    }

    public PhdCustomAlertBean(PhdIndividualProgramProcess process2, Boolean sendEmail2, Boolean userDefined, Boolean shared) {
        this.setProcess(process2);
        this.setToSendEmail(sendEmail2);
        this.setUserDefined(userDefined);
        this.setShared(shared);
    }

    public PhdAlertTargetGroupType getTargetGroupType() {
        return this.targetGroupType;
    }

    public void setTargetGroupType(PhdAlertTargetGroupType targetGroupType) {
        this.targetGroupType = targetGroupType;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean isToSendEmail() {
        return this.toSendEmail;
    }

    public void setToSendEmail(boolean toSendEmail) {
        this.toSendEmail = toSendEmail;
    }

    public LocalDate getFireDate() {
        return this.fireDate;
    }

    public void setFireDate(LocalDate fireDate) {
        this.fireDate = fireDate;
    }

    public void setTargetGroup(Group targetGroup) {
        this.targetGroup = targetGroup;
    }

    public Group getTargetGroup() {
        return this.targetGroup;
    }

    public Group calculateTargetGroup() {
        if (this.getTargetGroup() != null) {
            return this.getTargetGroup();
        }
        switch (this.getTargetGroupType()) {
            case MASTER_DEGREE_ADMINISTRATIVE_OFFICE_PERSONS: {
                return AcademicAuthorizationGroup.get(AcademicOperationType.MANAGE_PHD_PROCESSES, (AcademicProgram)((Object)this.getProcess().getPhdProgram()));
            }
            case ONLY_FOR_ME: {
                return UserGroup.of((User[])new User[]{Authenticate.getUser()});
            }
        }
        throw new RuntimeException("Target group type not supported");
    }

    public Person getPersonToAdd() {
        return this.personToAdd;
    }

    public void setPersonToAdd(Person personToAdd) {
        this.personToAdd = personToAdd;
    }

    public Boolean getUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(Boolean userDefined) {
        this.userDefined = userDefined;
    }

    public Boolean getShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public PhdIndividualProgramProcess getProcess() {
        return this.process;
    }

    public void setProcess(PhdIndividualProgramProcess process2) {
        this.process = process2;
    }

    static enum PhdAlertTargetGroupType {
        MASTER_DEGREE_ADMINISTRATIVE_OFFICE_PERSONS,
        ONLY_FOR_ME;

    }
}

