/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.log;

import java.math.BigDecimal;
import java.util.Iterator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.log.DismissalLog_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.util.EnrolmentAction;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class DismissalLog
extends DismissalLog_Base {
    protected DismissalLog() {
    }

    public DismissalLog(EnrolmentAction action, Registration registration, CurricularCourse curricularCourse, Credits credits, ExecutionSemester executionSemester, String who) {
        this();
        this.init(action, registration, (DegreeModule)((Object)curricularCourse), executionSemester, who);
        this.setCredits(BigDecimal.valueOf(credits.getGivenCredits()));
        this.setSourceDescription(this.buildSourceDescription(credits));
    }

    protected String buildSourceDescription(Credits credits) {
        StringBuilder result = new StringBuilder();
        Iterator<IEnrolment> enrolments = credits.getIEnrolments().iterator();
        while (enrolments.hasNext()) {
            result.append(enrolments.next().getName().getContent());
            result.append(enrolments.hasNext() ? ", " : "");
        }
        return result.toString();
    }

    public String getDescription() {
        StringBuilder description = new StringBuilder();
        description.append(this.getLabel()).append(": ");
        if (this.getDegreeModule() != null) {
            description.append(this.getDegreeModuleName());
        }
        if (this.hasCredits()) {
            description.append(" ; ").append(this.getCredits().toString());
        }
        if (this.hasSourceDescription()) {
            description.append(" ; ").append(this.getSourceDescription());
        }
        return description.toString();
    }

    private boolean hasCredits() {
        return this.getCredits() != null;
    }

    private boolean hasSourceDescription() {
        return this.getSourceDescription() != null && !this.getSourceDescription().isEmpty();
    }

    protected String getDegreeModuleName() {
        return ((CurricularCourse)((Object)this.getDegreeModule())).getName(this.getExecutionPeriod());
    }

    protected String getLabel() {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.dismissal", (String[])new String[0]);
    }
}

