/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.documents;

import java.util.Comparator;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.documents.GeneratedDocumentType;
import org.fenixedu.academic.domain.documents.GeneratedDocument_Base;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.ReadableInstant;

public abstract class GeneratedDocument
extends GeneratedDocument_Base {
    public static final Comparator<GeneratedDocument> COMPARATOR_BY_UPLOAD_TIME = new Comparator<GeneratedDocument>(){

        @Override
        public int compare(GeneratedDocument o1, GeneratedDocument o2) {
            return o1.getCreationDate().compareTo((ReadableInstant)o2.getCreationDate());
        }
    };

    protected void init(GeneratedDocumentType type, Party addressee, Person operator, String filename, byte[] content) {
        this.setType(type);
        this.setAddressee(addressee);
        this.setOperator(operator);
        this.init(filename, filename, content);
    }

    public void delete() {
        this.setAddressee(null);
        this.setOperator(null);
        super.delete();
    }

    public boolean isAccessible(User user) {
        if (user == null || user.getPerson() == null) {
            return false;
        }
        if (user.getPerson().equals((Object)this.getOperator())) {
            return true;
        }
        return user.getPerson().equals(this.getAddressee());
    }
}

