/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.degreeStructure.BibliographicReferences;

public class Externalization {
    private static final String NEW_LINE = "\r\n";
    private static final String ELEMENT_SEPARATOR = "||";

    public static String externalizeBibliographicReferences(BibliographicReferences source) {
        return Externalization.write(source);
    }

    public static BibliographicReferences internalizeBibliographicReferences(String source) {
        if (source != null && source.length() > 0) {
            return Externalization.read(source);
        }
        return new BibliographicReferences();
    }

    private static String write(BibliographicReferences bibliographicReferences) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<BibliographicReferences.BibliographicReference> references = bibliographicReferences.getBibliographicReferencesList().iterator();
        while (references.hasNext()) {
            Externalization.write(stringBuilder, references.next());
            if (!references.hasNext()) continue;
            stringBuilder.append(NEW_LINE);
        }
        return stringBuilder.toString();
    }

    private static void write(StringBuilder stringBuilder, BibliographicReferences.BibliographicReference reference) {
        stringBuilder.append(reference.getYear()).append(ELEMENT_SEPARATOR);
        stringBuilder.append(reference.getTitle()).append(ELEMENT_SEPARATOR);
        stringBuilder.append(reference.getAuthors()).append(ELEMENT_SEPARATOR);
        stringBuilder.append(reference.getReference()).append(ELEMENT_SEPARATOR);
        stringBuilder.append(StringUtils.isEmpty((String)reference.getUrl()) ? "" : reference.getUrl()).append(ELEMENT_SEPARATOR);
        stringBuilder.append((Object)reference.getType()).append(ELEMENT_SEPARATOR);
        stringBuilder.append(reference.getOrder());
    }

    private static BibliographicReferences read(String source) {
        ArrayList<BibliographicReferences.BibliographicReference> refs = new ArrayList<BibliographicReferences.BibliographicReference>();
        Externalization.fillBibliographicReferences(refs, source);
        return new BibliographicReferences(refs);
    }

    private static void fillBibliographicReferences(List<BibliographicReferences.BibliographicReference> refs, String source) {
        int indexOfSep1 = source.indexOf(ELEMENT_SEPARATOR);
        int indexOfSep2 = source.indexOf(ELEMENT_SEPARATOR, indexOfSep1 + ELEMENT_SEPARATOR.length());
        int indexOfSep3 = source.indexOf(ELEMENT_SEPARATOR, indexOfSep2 + ELEMENT_SEPARATOR.length());
        int indexOfSep4 = source.indexOf(ELEMENT_SEPARATOR, indexOfSep3 + ELEMENT_SEPARATOR.length());
        int indexOfSep5 = source.indexOf(ELEMENT_SEPARATOR, indexOfSep4 + ELEMENT_SEPARATOR.length());
        int indexOfSep6 = source.indexOf(ELEMENT_SEPARATOR, indexOfSep5 + ELEMENT_SEPARATOR.length());
        int temp = source.indexOf(NEW_LINE, indexOfSep6 + ELEMENT_SEPARATOR.length());
        int indexOfSep7 = temp < 0 ? source.length() : temp;
        refs.add(new BibliographicReferences.BibliographicReference(source.substring(0, indexOfSep1), source.substring(indexOfSep1 + ELEMENT_SEPARATOR.length(), indexOfSep2), source.substring(indexOfSep2 + ELEMENT_SEPARATOR.length(), indexOfSep3), source.substring(indexOfSep3 + ELEMENT_SEPARATOR.length(), indexOfSep4), source.substring(indexOfSep4 + ELEMENT_SEPARATOR.length(), indexOfSep5), source.substring(indexOfSep5 + ELEMENT_SEPARATOR.length(), indexOfSep6).equals("null") ? BibliographicReferences.BibliographicReferenceType.MAIN : BibliographicReferences.BibliographicReferenceType.valueOf(source.substring(indexOfSep5 + ELEMENT_SEPARATOR.length(), indexOfSep6)), Integer.valueOf(source.substring(indexOfSep6 + ELEMENT_SEPARATOR.length(), indexOfSep7))));
        if (indexOfSep7 + NEW_LINE.length() < source.length()) {
            Externalization.fillBibliographicReferences(refs, source.substring(indexOfSep7 + NEW_LINE.length()));
        }
    }
}

